﻿Option Strict On
Option Explicit On
Option Infer Off

Imports Microsoft.Win32

Public Class Form1

#Region "Moje dokumenty"
    Private Shared Function PobierzSciezkeDoKataloguSpecjalnego(nazwaWartosci As String) As String
        Const nazwaKlucza As String = "Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders"
        Try
            Dim rejestr As RegistryKey = Registry.CurrentUser.OpenSubKey(nazwaKlucza)
            If rejestr Is Nothing Then Throw New Exception("brak klucza '" & nazwaKlucza & "'")
            Dim wartosc As Object = rejestr.GetValue(nazwaWartosci)
            If wartosc Is Nothing Then
                Throw New Exception("brak wartosci '" & nazwaWartosci & "'")
            End If
            Dim sciezkaKatalogu As String = wartosc.ToString()
            rejestr.Close()
            Return sciezkaKatalogu
        Catch exc As Exception
            MessageBox.Show("Błąd przy czytaniu rejestru: " & exc.Message & ".")
            Return Nothing
        End Try
    End Function

    Private Shared Function SciezkaMojeDokumenty() As String
        Return PobierzSciezkeDoKataloguSpecjalnego("Personal")
    End Function

    Private ReadOnly Property _SciezkaMojeDokumenty As String
        Get
            Return PobierzSciezkeDoKataloguSpecjalnego("Personal")
        End Get
    End Property
#End Region

#Region "Rozmiar i położenie formy"
    Const kluczAplikacji As String = "Software\Helion\PrzykladRejestr"

    Private Sub CzytajPolozenieOkna(nazwaKlucza As String)
        Dim rejestr As RegistryKey = Registry.CurrentUser.OpenSubKey(nazwaKlucza)
        If rejestr Is Nothing Then
            'tu można umieścić polecenia wykonywane przy pierwszym uruchomieniu aplikacji
            MessageBox.Show("Pierwsze uruchomienie programu.", Me.Text)
            Return
        End If
        'x
        Dim wartosc As Object = rejestr.GetValue("left")
        If wartosc IsNot Nothing Then Me.Left = CInt(wartosc)
        'y
        wartosc = rejestr.GetValue("top")
        If wartosc IsNot Nothing Then Me.Top = CInt(wartosc)
        'szer
        wartosc = rejestr.GetValue("width")
        If wartosc IsNot Nothing Then Me.Width = CInt(wartosc)
        'wys
        wartosc = rejestr.GetValue("height")
        If wartosc IsNot Nothing Then Me.Height = CInt(wartosc)
        rejestr.Close()
    End Sub

    Private Sub ZapiszPolozenieOkna(nazwaKlucza As String)
        Dim rejestr As RegistryKey = Registry.CurrentUser.OpenSubKey(nazwaKlucza, True)
        If rejestr Is Nothing Then
            'pierwsze uruchomienie programu po instalacji
            MessageBox.Show("Tworzę klucz rejestru dla aplikacji", Me.Text)
            rejestr = Registry.CurrentUser.CreateSubKey(nazwaKlucza)
        End If
        rejestr.SetValue("left", Me.Left)
        rejestr.SetValue("top", Me.Top)
        rejestr.SetValue("width", Me.Width)
        rejestr.SetValue("height", Me.Height)
        rejestr.Close()
    End Sub
#End Region

    Public Sub New()
        InitializeComponent()
        Label1.Text = SciezkaMojeDokumenty()
        'Label1.Text = _SciezkaMojeDokumenty
    End Sub

    Private Sub Form1_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        Try
            CzytajPolozenieOkna(kluczAplikacji)
        Catch ex As Exception
            MessageBox.Show("Błąd przy odtwarzaniu położenia okna:" & vbNewLine & ex.Message)
        End Try
    End Sub

    Private Sub Form1_FormClosed(sender As System.Object, e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed
        ZapiszPolozenieOkna(kluczAplikacji)
    End Sub

    Private Sub Button1_Click(sender As System.Object, e As System.EventArgs) Handles Button1.Click
        Registry.CurrentUser.DeleteSubKey(kluczAplikacji, False)
    End Sub
End Class
