﻿Imports System.ComponentModel

Public Class ColorProgressBar

    Private Sub ColorProgressBar_Paint(sender As System.Object, e As System.Windows.Forms.PaintEventArgs) Handles MyBase.Paint
        BackColor = Me.Parent.BackColor

        'brzegi
        Dim cien As Pen = New Pen(SystemColors.ControlDark)
        Dim swiatlo As Pen = New Pen(SystemColors.ControlLightLight)
        e.Graphics.DrawLine(cien, 0, Height - 1, 0, 0)
        e.Graphics.DrawLine(cien, 0, 0, Width - 1, 0)
        e.Graphics.DrawLine(swiatlo, Width - 1, 0, Width - 1, Height - 1)
        e.Graphics.DrawLine(swiatlo, Width - 1, Height - 1, 0, Height - 1)

        'pasek
        Dim bufor As Bitmap = New Bitmap(Width, Height)
        Dim g As Graphics = Graphics.FromImage(bufor)
        BackColor = Me.Parent.BackColor

        Const margines As Integer = 2
        Dim stepwidth As Integer = 2 * Height \ 3
        Dim procenty As Double = 0
        If Maximum > Minimum Then procenty = (Value - Minimum) / (Maximum - Minimum)
        Dim szerokosc As Integer = Int(Math.Round(procenty * (Width - 2 * margines - 1)))
        For i = margines To margines + szerokosc - 1
            If Not Smooth And (i Mod stepwidth) > 0 And (i Mod stepwidth) < margines + 1 Then Continue For
            g.DrawLine(New Pen(ObliczKolor(i)), i, margines, i, Height - margines - 1)
        Next

        e.Graphics.DrawImage(bufor, 0, 0)
    End Sub

    Private Function ObliczKolor(i As Integer) As Color
        If i < 0 Or i > Width Then Throw New Exception("Zly parametr i")
        Return Color.FromArgb(
            ColorBegin.R + i * (CInt(ColorEnd.R) - ColorBegin.R) \ Width,
            ColorBegin.G + i * (CInt(ColorEnd.G) - ColorBegin.G) \ Width,
            ColorBegin.B + i * (CInt(ColorEnd.B) - ColorBegin.B) \ Width)
    End Function

    Private Sub ColorProgressBar_Resize(sender As System.Object, e As System.EventArgs) Handles MyBase.Resize
        Refresh()
    End Sub


#Region "Wlasnosci"
    Private _minimum As Integer = 0
    Private _maximum As Integer = 100
    Private _value As Integer = 0
    Private _colorBegin As Color = Color.Yellow
    Private _colorEnd As Color = Color.Red
    Private _smooth As Boolean = False

    <Category("Behavior"), Description("Dolna granica zakresu wartości, jakie mogą być prezentowane przez komponent.")>
    Public Property Minimum As Integer
        Get
            Return _minimum
        End Get
        Set(value As Integer)
            If value > _maximum Then value = _maximum
            _minimum = value
            Refresh()
        End Set
    End Property

    <Category("Behavior"), Description("Górna granica zakresu wartości, jakie mogą być prezentowane przez komponent.")>
    Public Property Maximum As Integer
        Get
            Return _maximum
        End Get
        Set(value As Integer)
            If value < _minimum Then value = _minimum
            _maximum = value
            Refresh()
        End Set
    End Property

    <Category("Behavior"), Description("Wartość prezentowana przez komponent.")>
    Public Property Value As Integer
        Get
            Return _value
        End Get
        Set(value As Integer)
            If value < _minimum Then value = _minimum
            If value > _maximum Then value = _maximum
            If _value <> value Then
                _value = value
                OnValueChanged(Me, New EventArgs(), value)
                Refresh()
            End If
        End Set
    End Property

    <Category("Behavior"), Description("Wielkość, o którą zwiększana jest własność Value przez metodę PerformStep().")>
    Public Property [Step] As Integer = 10

    <Category("Appearance"), Description("Pierwszy kolor wyznaczający gradient barw widoczny na pasku postępu.")>
    Public Property ColorBegin As Color
        Get
            Return _colorBegin
        End Get
        Set(value As Color)
            _colorBegin = value
            Refresh()
        End Set
    End Property

    <Category("Appearance"), Description("Drugi kolor wyznaczający gradient barw widoczny na pasku postępu.")>
    Public Property ColorEnd As Color
        Get
            Return _colorEnd
        End Get
        Set(value As Color)
            _colorEnd = value
            Refresh()
        End Set
    End Property

    <Category("Appearance"), Description("Jeżeli wartość ta równa jest true, pasek jest gładki.")>
    Public Property Smooth As Boolean
        Get
            Return _smooth
        End Get
        Set(value As Boolean)
            _smooth = value
            Refresh()
        End Set
    End Property
#End Region

    Public Sub PerformStep()
        Value += Me.Step
    End Sub

#Region "Zdarzenie ValueChanged"
    Public Delegate Sub ValueChangedEventHandler(ByVal sender As Object, ByVal e As EventArgs, ByVal value As Integer)

    <Category("Behavior"), Description("Zachodzi w przypadku zmiany własności Value.")>
    Public Event ValueChanged As ValueChangedEventHandler

    Protected Overridable Sub OnValueChanged(ByVal sender As Object, ByVal e As EventArgs, ByVal value As Integer)
        RaiseEvent ValueChanged(Me, e, value)
    End Sub
#End Region

End Class
