﻿Option Strict On
Option Explicit On
Option Infer Off

Imports System.Windows.Forms

Public Class SystemInfo
    Public Shared Function [Get]() As String
        Dim informacje As String = "Informacje o systemie:" &
                vbNewLine & "Wersja systemu: " & Environment.OSVersion.ToString() &
                vbNewLine & "Wersja Microsoft .NET Framework: " & Environment.Version.ToString() &
                vbNewLine & "Nazwa komputera: " & Environment.MachineName &
                vbNewLine & "Katalog systemowy: " & Environment.SystemDirectory
        Return informacje
    End Function

    Public Shared Sub Show()
        Dim informacje As String = [Get]()
        MessageBox.Show(informacje, "Informacje o platformie .NET")
    End Sub

    Public Function GetSystemInfo(ByRef informacje As String, Optional czyWyswietlac As Boolean = False) As Integer
        informacje = [Get]()
        If czyWyswietlac Then _
            System.Windows.Forms.MessageBox.Show(informacje, "Informacje o platformie .NET")
        Return Environment.Version.Major
    End Function

    Public Function GetSystemInfoBuilder(informacje As System.Text.StringBuilder, Optional czyWyswietlac As Boolean = False) As Integer
        Dim s As String = Nothing
        Dim wynik As Integer = GetSystemInfo(s, czyWyswietlac)
        informacje.Append(s)
        Return wynik
    End Function

End Class

Namespace DodatkowaPrzestrzenNazw
    Public Class Dodatkowa
        Public Class Zagniezdzona
        End Class
    End Class
End Namespace