﻿Option Strict On
Option Explicit On
Option Infer Off

Imports System.Xml.Serialization
Imports System.IO

Public Class Form1
    Private plikUstawien As String = "Ustawienia.xml"

    Private Sub Form1_FormClosed(sender As System.Object, e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed
        Dim sw As StreamWriter = Nothing
        Try
            Dim okno As Okno = New Okno(New Point(Left, Top), New WielkośćOkna(Width, Height))
            Dim xmlsrl As XmlSerializer = New XmlSerializer(GetType(Okno))
            sw = New StreamWriter(plikUstawien)
            xmlsrl.Serialize(sw, okno)
        Catch exc As Exception
            MessageBox.Show("Błąd w zapisywaniu ustawień z pliku (" & exc.Message & ")")
        Finally
            If sw IsNot Nothing Then sw.Close()
        End Try
    End Sub

    Private Sub Form1_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        Dim sr As StreamReader = Nothing
        Try
            Dim xmlsrl As XmlSerializer = New XmlSerializer(GetType(Okno))
            sr = New StreamReader(plikUstawien)
            Dim okno As Okno = CType(xmlsrl.Deserialize(sr), Okno)

            Me.Left = okno.pozycja.X
            Me.Top = okno.pozycja.Y
            Me.Width = okno.wielkość.Szer
            Me.Height = okno.wielkość.Wys
        Catch exc As Exception
            MessageBox.Show("Błąd w odczytywaniu ustawień z pliku (" & exc.Message & ")")
        Finally
            If sr IsNot Nothing Then sr.Close()
        End Try
    End Sub
End Class

Public Structure WielkośćOkna
    Public Szer As Integer
    Public Wys As Integer
    Public Sub New(Szer As Integer, Wys As Integer)
        Me.Szer = Szer
        Me.Wys = Wys
    End Sub
End Structure

Public Structure Okno
    Public pozycja As Point
    Public wielkość As WielkośćOkna
    Public Sub New(pozycja As Point, wielkość As WielkośćOkna)
        Me.pozycja = pozycja
        Me.wielkość = wielkość
    End Sub
End Structure