﻿Option Strict On
Option Explicit On
Option Infer Off

Imports System.Numerics

Public Class Form1

    Private Sub Form1_Paint(sender As System.Object, e As System.Windows.Forms.PaintEventArgs) Handles MyBase.Paint
        Text = "Czekaj..."
        Cursor = Cursors.WaitCursor

        Dim min As Complex = New Complex(-2.2, -1.2) 'min,max - zakres badanej płaszczyzny zespolonej
        Dim max As Complex = New Complex(1.2, 1.2)
        'Dim min As Complex = New Complex(0.2016, 0.541)
        'Dim max As Complex = New Complex(0.2175, 0.5521)
        Dim bufor As Bitmap = New Bitmap(ClientSize.Width, ClientSize.Height)

        For x As Integer = 0 To bufor.Width - 1 'x,y - współrzędne pikseli
            For y As Integer = 0 To bufor.Height - 1
                'Mandelbrot
                Dim c As Complex = min + New Complex(x * (max.Real - min.Real) / bufor.Width,
                                                     y * (max.Imaginary - min.Imaginary) / bufor.Height)
                Dim z As Complex = 0

                'Julia
                'Dim c As Complex = New Complex(0.25, 0.55)
                'Dim z As Complex = min + New Complex(x * (max.Real - min.Real) / bufor.Width,
                '                                     y * (max.Imaginary - min.Imaginary) / bufor.Height)


                Dim indeks As Byte = 0
                Const jeden As Byte = 1 'stala pomocnicza, w VB nie ma literalu typu Byte
                While indeks < 255
                    z = z * z + c
                    If z.Magnitude >= 4 Then Exit While
                    indeks += jeden
                End While
                Dim kolor As Color = If(indeks = 255, Color.Black, Color.FromArgb(255 - indeks, 255 - indeks, 255))
                bufor.SetPixel(x, y, kolor)
            Next
        Next

        e.Graphics.DrawImage(bufor, 0, 0)

        Text = "Zbiór Mandelbrota"
        'Text = "Zbiór Julii"
        Cursor = Cursors.Arrow
    End Sub
End Class
