﻿Option Strict On
Option Explicit On
Option Infer Off

Imports System.Runtime.CompilerServices

Module Rozszerzenia
    <Extension()>
    Public Function UsunApostrof(ByVal argument As String) As String
        Return argument.Replace("'"c, "#"c)
    End Function

    <Extension()>
    Public Function UsunApostrof(ByVal argument As String, ByVal zamiennik As Char) As String
        Return argument.Replace("'"c, zamiennik)
    End Function

    <Extension()>
    Public Function UsunApostrof(ByVal argument As String, ByVal zmieniacz As Func(Of Char, Char)) As String
        Dim wynik As String = ""
        For Each znak As Char In argument.ToCharArray()
            wynik &= zmieniacz(znak)
        Next
        Return wynik
    End Function

    <Extension()>
    Public Function TypJakoLancuch(ByVal argument As Object) As String
        Return argument.GetType().FullName
    End Function

    <Extension()>
    Public Sub ShowMessage(ByVal argument As Object)
        MessageBox.Show(argument.ToString())
    End Sub

End Module

Public Class Form1

    Private Sub Button1_Click(sender As System.Object, e As System.EventArgs) Handles Button1.Click
        MessageBox.Show("SQL Inje'c'tion".UsunApostrof())
        MessageBox.Show("SQL Inje'c'tion".UsunApostrof("#"c))
        MessageBox.Show("SQL Inje'c'tion".UsunApostrof(Function(c) If(c = "'"c, "#"c, c)))

        Dim i As Integer = 1
        MsgBox(i.TypJakoLancuch())
        i.ShowMessage()

        Dim b As Button = New Button()
        MsgBox(b.TypJakoLancuch())
        b.ShowMessage()
    End Sub
End Class

