﻿Option Strict On
Option Explicit On
Option Infer Off

Public Class Form1
    Dim obraz As Bitmap = Nothing
    Dim czyPrzenoszenie As Boolean = False
    Dim x0, y0 As Integer

    Public Sub New()
        InitializeComponent()

        'Wczytywanie obrazu formy
        obraz = New Bitmap("KsztaltFormy.bmp")
        obraz.MakeTransparent(Me.BackColor)
        Me.Bounds = New Rectangle(0, 0, obraz.Width, obraz.Height)
    End Sub

    Private Sub Form1_Paint(sender As System.Object, e As System.Windows.Forms.PaintEventArgs) Handles MyBase.Paint
        e.Graphics.DrawImage(obraz, 0, 0)
    End Sub

    Private Sub Form1_FormClosed(sender As System.Object, e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed
        For i As Double = Opacity To 0 Step -0.001
            Opacity = i
        Next
    End Sub

    Private Sub Form1_KeyPress(sender As System.Object, e As System.Windows.Forms.KeyPressEventArgs) Handles MyBase.KeyPress
        If e.KeyChar = Chr(27) Then Me.Close()
        If e.KeyChar = " " Or e.KeyChar = Chr(13) Then Me.WindowState = FormWindowState.Minimized
    End Sub

    Private Sub Form1_MouseDown(sender As System.Object, e As System.Windows.Forms.MouseEventArgs) Handles MyBase.MouseDown
        If e.Button = MouseButtons.Left Then
            Cursor.Current = Cursors.Hand
            czyPrzenoszenie = True
            x0 = e.X
            y0 = e.Y
        End If
    End Sub

    Private Sub Form1_MouseMove(sender As System.Object, e As System.Windows.Forms.MouseEventArgs) Handles MyBase.MouseMove
        If czyPrzenoszenie Then
            Left += e.X - x0
            Top += e.Y - y0
        End If
    End Sub

    Private Sub Form1_MouseUp(sender As System.Object, e As System.Windows.Forms.MouseEventArgs) Handles MyBase.MouseUp
        If czyPrzenoszenie Then
            Cursor.Current = Cursors.Default
            czyPrzenoszenie = False
        End If
    End Sub

    Private Sub ZawszeWidoczneToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles ZawszeWidoczneToolStripMenuItem.Click
        ZawszeWidoczneToolStripMenuItem.Checked = Not ZawszeWidoczneToolStripMenuItem.Checked
        Me.TopMost = ZawszeWidoczneToolStripMenuItem.Checked
    End Sub

    Private Sub PrzezroczystośćToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles PrzezroczystośćToolStripMenuItem.Click
        PrzezroczystośćToolStripMenuItem.Checked = Not PrzezroczystośćToolStripMenuItem.Checked
        Me.Opacity = If(PrzezroczystośćToolStripMenuItem.Checked, 0.5, 1)
    End Sub

    Private Sub UsuńZPaskaZadańToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles UsuńZPaskaZadańToolStripMenuItem.Click
        UsuńZPaskaZadańToolStripMenuItem.Checked = Not UsuńZPaskaZadańToolStripMenuItem.Checked
        Me.ShowInTaskbar = Not UsuńZPaskaZadańToolStripMenuItem.Checked
    End Sub

    Private Sub StronaHelionToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles StronaHelionToolStripMenuItem.Click
        System.Diagnostics.Process.Start("http://helion.pl")
    End Sub

    Private Sub StronaAutoraToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles StronaAutoraToolStripMenuItem.Click
        System.Diagnostics.Process.Start("http://www.fizyka.umk.pl/~jacek")
    End Sub

    Private Sub UkryjToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles UkryjToolStripMenuItem.Click
        Me.WindowState = FormWindowState.Minimized
    End Sub

    Private Sub ZamknijToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles ZamknijToolStripMenuItem.Click
        Me.Close()
    End Sub
End Class
