﻿Imports Microsoft.DirectX
Imports Microsoft.DirectX.Direct3D

Public Class OctahedronForm
    ' Urządzenie Direct3D.
    Private m_Device As Device

    ' Zmienne.
    Private Const NUM_TRIANGLES As Integer = 8
    Private Const NUM_POINTS As Integer = 3 * NUM_TRIANGLES

    ' Bufor wierzchołków, który przechowuje dane rysunku.
    Private m_VertexBuffer As VertexBuffer = Nothing

    ' Inicjuje urządzenie graficzne. W razie powodzenia zwraca True.
    Public Function InitializeGraphics() As Boolean
        Try
            Dim params As New PresentParameters
            params.Windowed = True
            params.SwapEffect = SwapEffect.Discard

            ' Użycie sprzętowego przetwarzania wierzchołków, jeśli jest obsługiwane.
            'm_Device = New Device(0, DeviceType.Hardware, Me, _
            '    CreateFlags.HardwareVertexProcessing, params)
            m_Device = New Device(0, DeviceType.Hardware, Me, _
                CreateFlags.SoftwareVertexProcessing, params)
            'm_Device = New Device(0, DeviceType.Reference, Me, _
            '    CreateFlags.SoftwareVertexProcessing, params)

            ' Wyłącza oświetlenie D3D, ponieważ 
            ' kolory wierzchołków zostały ustawione bezpośrednio.
            m_Device.RenderState.Lighting = False

            ' Tworzy dane wierzchołków.
            CreateVertexBuffer()

            Return True
        Catch ex As Exception
            MessageBox.Show("Błąd podczas inicjacji Direct3D" & _
                vbCrLf & vbCrLf & ex.Message, _
                "Błąd Direct3D", MessageBoxButtons.OK)
            Return False
        End Try
    End Function

    Public Sub Render()
        If m_Device Is Nothing Then Exit Sub

        ' Czyści bufor tylny.
        m_Device.Clear(ClearFlags.Target, Me.BackColor, 1, 0)

        ' Tworzy scenę.
        m_Device.BeginScene()

        ' Tworzy macierze świata, widoku oraz projekcji.
        SetupMatrices()

        ' Ustawienie źródła danych strumienia urządzenia (bufor wierzchołków).
        m_Device.SetStreamSource(0, m_VertexBuffer, 0)

        ' Informuje urządzenie o formacie wierzchołków.
        m_Device.VertexFormat = CustomVertex.PositionColored.Format

        ' Rysuje obiekty proste w strumieniu danych.
        m_Device.DrawPrimitives(PrimitiveType.TriangleList, 0, NUM_TRIANGLES)

        ' Kończy scenę i wyświetla obraz.
        m_Device.EndScene()
        m_Device.Present()
    End Sub

    ' Tworzy bufor wierzchołków dla urządzenia.
    Public Sub CreateVertexBuffer()
        ' Tworzy bufor wierzchołków.
        m_VertexBuffer = New VertexBuffer( _
            GetType(CustomVertex.PositionColored), _
            NUM_POINTS, m_Device, 0, _
            CustomVertex.PositionColored.Format, _
            Pool.Default)

        ' Blokuje bufor wierzchołków.
        ' Blokada zwraca tablicę obiektów positionColored.
        Dim vertices As CustomVertex.PositionColored() = _
            CType(m_VertexBuffer.Lock(0, 0),  _
                CustomVertex.PositionColored())
        Dim start_index As Integer = 0

        Const WID As Single = 2
        MakeTriangle(vertices, start_index, Color.Red, _
            0, WID, 0, _
            0, 0, WID, _
            WID, 0, 0)
        MakeTriangle(vertices, start_index, Color.Yellow, _
            0, WID, 0, _
            WID, 0, 0, _
            0, 0, -WID)
        MakeTriangle(vertices, start_index, Color.Red, _
            0, WID, 0, _
            0, 0, -WID, _
            -WID, 0, 0)
        MakeTriangle(vertices, start_index, Color.Yellow, _
            0, WID, 0, _
            -WID, 0, 0, _
            0, 0, WID)
        MakeTriangle(vertices, start_index, Color.Blue, _
            0, -WID, 0, _
            WID, 0, 0, _
            0, 0, WID)
        MakeTriangle(vertices, start_index, Color.Green, _
            0, -WID, 0, _
            0, 0, -WID, _
            WID, 0, 0)
        MakeTriangle(vertices, start_index, Color.Blue, _
            0, -WID, 0, _
            -WID, 0, 0, _
            0, 0, -WID)
        MakeTriangle(vertices, start_index, Color.Green, _
            0, -WID, 0, _
            0, 0, WID, _
            -WID, 0, 0)

        m_VertexBuffer.Unlock()
    End Sub

    Private Sub MakeTriangle( _
        ByVal vertices As CustomVertex.PositionColored(), _
        ByRef start_index As Integer, ByVal clr As Color, _
        ByVal x1 As Single, ByVal y1 As Single, ByVal z1 As Single, _
        ByVal x2 As Single, ByVal y2 As Single, ByVal z2 As Single, _
        ByVal x3 As Single, ByVal y3 As Single, ByVal z3 As Single)

        With vertices(start_index)
            .X = x1
            .Y = y1
            .Z = z1
            .Color = clr.ToArgb()
        End With
        start_index += 1

        With vertices(start_index)
            .X = x2
            .Y = y2
            .Z = z2
            .Color = clr.ToArgb()
        End With
        start_index += 1

        With vertices(start_index)
            .X = x3
            .Y = y3
            .Z = z3
            .Color = clr.ToArgb()
        End With
        start_index += 1
    End Sub

    ' Tworzy macierze świata, widoku oraz projekcji.
    Private Sub SetupMatrices()
        ' Macierz świata:
        ' obraca obiekt wokół osi Y o
        ' 2 * Pi radianów na 2000 tyknięć (2 sekundy).
        Const TICKS_PER_REV As Integer = 2000
        Dim ms_rotated As Integer = Environment.TickCount Mod TICKS_PER_REV
        Dim angle As Double = ms_rotated * (2 * Math.PI) / TICKS_PER_REV
        m_Device.Transform.World = Matrix.RotationY(CSng(angle))

        ' Macierz widoku:
        ' została zdefiniowana poprzez określenie:
        '       położenia obserwatora   (0, 3, -10)
        '       położenia obiektu       (0, 0, 0)
        '       kierunku w „górę"        <0, 1, 0>
        m_Device.Transform.View = Matrix.LookAtLH( _
            New Vector3(0, 3, -10), _
            New Vector3(0, 0, 0), _
            New Vector3(0, 1, 0))

        ' Macierz projekcji:
        ' Transformacja perspektywy zdefiniowana poprzez określenie:
        '       pola widoku             Pi / 4
        '       współczynnika proporcji 1
        '       bliskiej płaszczyzny    Z = 1
        '       dalekiej płaszczyzny    Z = 100
        m_Device.Transform.Projection = _
            Matrix.PerspectiveFovLH(Math.PI / 4, 1, 1, 100)
    End Sub
End Class
