Imports System.IO

Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        For Each drive_info As DriveInfo In DriveInfo.GetDrives()
            lstDrives.Items.Add(drive_info.Name)
        Next drive_info
    End Sub

    Private Sub lstDrives_SelectedIndexChanged() Handles lstDrives.SelectedIndexChanged
        For Each ctl As Control In Me.Controls
            If (ctl.Name.StartsWith("lbl")) AndAlso (TypeOf ctl Is Label) Then
                Dim lbl As Label = DirectCast(ctl, Label)
                lbl.Text = ""
            End If
        Next ctl

        Dim drive_info As New DriveInfo(lstDrives.Text)
        lblName.Text = drive_info.Name()
        lblIsReady.Text = drive_info.IsReady().ToString
        lblDriveType.Text = drive_info.DriveType().ToString
        lblRootDirectory.Text = drive_info.RootDirectory.ToString
        If drive_info.IsReady() Then
            lblAvailableFreeSpace.Text = drive_info.AvailableFreeSpace().ToString
            lblDriveFormat.Text = drive_info.DriveFormat()
            lblTotalFreeSpace.Text = FormatBytes(drive_info.TotalFreeSpace, "0.00")
            lblVolumeLabel.Text = drive_info.VolumeLabel()
        End If
    End Sub

    ' Formatowanie rozmiaru dysku w bajtach jako KB, MB, GB itd.
    Private Function FormatBytes(ByVal num_bytes As Double, ByVal format_str As String) As String
        Dim postfixes() As String = {"Bytes", "KB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"}
        For i As Integer = postfixes.Length - 1 To 0 Step -1
            If num_bytes > 1024 ^ i Then
                num_bytes /= 1024 ^ i
                Return num_bytes.ToString(format_str) & " " & postfixes(i)
            End If
        Next i

        Return num_bytes.ToString(format_str) & " Bytes"
    End Function
End Class
