﻿Imports Microsoft.Win32

Public Class Form1
    Private m_ConfigSection As RegistryKey

    ' Zamyka podklucz rejestru.
    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        m_ConfigSection.Close()
    End Sub

    ' Otwiera podklucz rejestryu.
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Const SUBKEY As String = "Software\VB and VBA Program Settings\MyComputerRegistry\Config"

        ' Otwiera podklucz konfiguracji.
        m_ConfigSection = My.Computer.Registry.CurrentUser.OpenSubKey(SUBKEY, True)

        ' Jeśli sekcja nie istnieje, tworzy ją.
        If m_ConfigSection Is Nothing Then
            m_ConfigSection = My.Computer.Registry.CurrentUser.CreateSubKey(SUBKEY)
        End If

        ' Wyśweitla aktualne ustawienia.
        ShowAllSettings()
    End Sub

    ' Pobiera ustawienie.
    Private Sub btnGet_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnGet.Click
        txtSettingValue.Text = m_ConfigSection.GetValue(txtSettingName.Text, "<Nothing>")
        ShowAllSettings()
    End Sub

    ' Zapisuje ustawienie.
    Private Sub btnSet_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSet.Click
        m_ConfigSection.SetValue(txtSettingName.Text, txtSettingValue.Text)
        ShowAllSettings()
    End Sub

    ' Wyświetla wszystkie ustawienia Config rejestru.
    Private Sub ShowAllSettings()
        lvSettings.Items.Clear()

        If m_ConfigSection.GetValueNames().Length > 0 Then
            For Each value_name As String In m_ConfigSection.GetValueNames()
                Dim new_item As ListViewItem = lvSettings.Items.Add(value_name)
                new_item.SubItems.Add(m_ConfigSection.GetValue(value_name))
            Next value_name
        End If
        lvSettings.Columns(0).Width = -2
        lvSettings.Columns(1).Width = -2
    End Sub

    ' Usuwa ustawienie.
    Private Sub btnDelete_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDelete.Click
        m_ConfigSection.DeleteValue(txtSettingName.Text)
        ShowAllSettings()
    End Sub

    ' Wyświetla nazwę wybranego ustawienia w polu tekstowym.
    Private Sub lvSettings_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lvSettings.SelectedIndexChanged
        txtSettingName.Clear()
        txtSettingValue.Clear()

        If lvSettings.SelectedItems.Count > 0 Then
            txtSettingName.Text = lvSettings.SelectedItems(0).Text
        End If
    End Sub
End Class
