﻿Imports System.Drawing.Printing

Public Class Form1
    Private WithEvents m_PrintDocument As PrintDocument

    ' Drukuje.
    Private Sub btnPrintNow_Click() Handles btnPrintNow.Click
        m_PrintDocument = New PrintDocument
        m_PrintDocument.Print()
    End Sub

    ' Wyświetla okno dialogowe podglądu wydruku.
    Private Sub btnPrintPreview_Click() Handles btnPrintPreview.Click
        m_PrintDocument = New PrintDocument
        dlgPrintPreview.Document = m_PrintDocument
        dlgPrintPreview.ShowDialog()
    End Sub

    ' Wyświetla okno dialogowe drukowania.
    Private Sub btnPrintDialog_Click() Handles btnPrintDialog.Click
        m_PrintDocument = New PrintDocument
        dlgPrint.Document = m_PrintDocument
        dlgPrint.ShowDialog()
    End Sub

    ' Drukuje stronę z rombem.
    Private Sub m_PrintDocument_PrintPage(ByVal sender As Object, ByVal e As System.Drawing.Printing.PrintPageEventArgs) Handles m_PrintDocument.PrintPage
        Dim pts() As Point = { _
            New Point(e.MarginBounds.Left + e.MarginBounds.Width \ 2, _
                e.MarginBounds.Top), _
            New Point(e.MarginBounds.Right, _
                e.MarginBounds.Top + e.MarginBounds.Height \ 2), _
            New Point(e.MarginBounds.Left + e.MarginBounds.Width \ 2, _
                e.MarginBounds.Bottom), _
            New Point(e.MarginBounds.Left, _
                e.MarginBounds.Top + e.MarginBounds.Height \ 2) _
        }

        Using the_pen As New Pen(Color.Black, 10)
            e.Graphics.DrawPolygon(the_pen, pts)
        End Using

        e.HasMorePages = False
    End Sub
End Class
