﻿Public Class Form1
    Private Sub mnuFileOpen_Click() Handles mnuFileOpen.Click
        If dlgOpenImage.ShowDialog() = Windows.Forms.DialogResult.OK Then
            ' Ładuje i wyświetla obraz.
            Dim bm As New Bitmap(dlgOpenImage.FileName)
            Dim source_bm As New Bitmap(bm)
            bm.Dispose()
            picSource.Image = source_bm

            ' Rozmieszcza kontrolki.
            picDest.Size = picSource.Size

            ' Konwertuje wynik na mapę bitową.
            Dim dest_bm As New Bitmap(source_bm)

            ' Odwraca piksele obrazu.
            Dim start_time As DateTime
            Dim stop_time As DateTime
            Dim elapsed_time As TimeSpan
            start_time = Now
            InvertImage(dest_bm)
            stop_time = Now

            ' Wyświetla wyniki.
            picDest.Image = dest_bm

            elapsed_time = stop_time.Subtract(start_time)
            MessageBox.Show(elapsed_time.TotalSeconds.ToString("0.0000") & " seconds")
        End If
    End Sub

    ' Odwraca wartości pikseli w tej mapie bitowej.
    Private Sub InvertImage(ByVal bm As Bitmap)
        ' Tworzy obiekt BitmapBytesRGB24.
        Dim bm_bytes As New BitmapBytesRGB24(bm)

        ' Blokuje mapę bitową.
        bm_bytes.LockBitmap()

        Dim pix As Integer
        For y As Integer = 0 To bm.Height - 1
            pix = y * bm_bytes.RowSizeBytes
            For x As Integer = 0 To bm.Width - 1
                ' Komponent niebieski.
                bm_bytes.ImageBytes(pix) = CByte(255) - bm_bytes.ImageBytes(pix)
                pix += 1
                ' Komponent zielony.
                bm_bytes.ImageBytes(pix) = CByte(255) - bm_bytes.ImageBytes(pix)
                pix += 1
                ' Komponent czerwony.
                bm_bytes.ImageBytes(pix) = CByte(255) - bm_bytes.ImageBytes(pix)
                pix += 1
            Next x
        Next y

        ' Odblokowuje mapę bitową.
        bm_bytes.UnlockBitmap()
    End Sub
End Class
