Imports System.Drawing.Imaging
Imports System.Runtime.InteropServices

Public Class BitmapBytesRGB24
    ' Publiczny dostp do danych bajtowych obrazu.
    Public ImageBytes() As Byte
    Public RowSizeBytes As Integer
    Public Const PixelDataSize As Integer = 24

    ' Referencja do mapy bitowej.
    Private m_Bitmap As Bitmap

    ' Zapisuje referencj do mapy bitowej.
    Public Sub New(ByVal bm As Bitmap)
        m_Bitmap = bm
    End Sub

    ' Dane mapy bitowej.
    Private m_BitmapData As BitmapData

    ' Blokuje dane mapy bitowej.
    Public Sub LockBitmap()
        ' Blokuje dane mapy bitowej.
        Dim bounds As Rectangle = New Rectangle( _
            0, 0, m_Bitmap.Width, m_Bitmap.Height)
        m_BitmapData = m_Bitmap.LockBits(bounds, _
            Imaging.ImageLockMode.ReadWrite, _
            Imaging.PixelFormat.Format24bppRgb)
        RowSizeBytes = m_BitmapData.Stride

        ' Przydziela pami mapie bitowej.
        Dim total_size As Integer = m_BitmapData.Stride * m_BitmapData.Height
        ReDim ImageBytes(total_size)

        ' Kopiuje dane do tablicy ImageBytes.
        Marshal.Copy(m_BitmapData.Scan0, ImageBytes, _
            0, total_size)
    End Sub

    ' Kopiuje dane z powrotem do obiektu Bitmap
    ' i zwalnia zasoby.
    Public Sub UnlockBitmap()
        ' Kopiuje dane z powrotem do mapy bitowej.
        Dim total_size As Integer = m_BitmapData.Stride * m_BitmapData.Height
        Marshal.Copy(ImageBytes, 0, _
            m_BitmapData.Scan0, total_size)

        ' Odblokowuje map bitow.
        m_Bitmap.UnlockBits(m_BitmapData)

        ' Zwalnia zasoby.
        ImageBytes = Nothing
        m_BitmapData = Nothing
    End Sub
End Class
