﻿Imports System.Drawing.Drawing2D

Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        Me.SetStyle(ControlStyles.AllPaintingInWmPaint Or ControlStyles.ResizeRedraw, True)
        Me.UpdateStyles()
    End Sub

    Private Sub Form1_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles MyBase.Paint
        ' Definicja prostokąta rozkładu. Jest nieco mniejszy od
        ' obróconego o 90 stopni formularza, dzięki czemu obrócony tekst
        ' będzie dobrze pasować.
        Dim rect_wid As Integer = Me.ClientSize.Height - 20
        Dim rect_hgt As Integer = Me.ClientSize.Width - 20
        Dim layout_rect As New RectangleF( _
            (Me.ClientSize.Width - rect_wid) \ 2, _
            (Me.ClientSize.Height - rect_hgt) \ 2, _
            rect_wid, rect_hgt)

        ' Definicja tekstu i fontu.
        Dim txt As String = "The quick brown fox jumps over the lazy dog."
        Using the_font As New Font("Times New Roman", 30, FontStyle.Bold, GraphicsUnit.Pixel)
            ' ustawia StringFormat na wyśrodkowanie tekstu.
            Using string_format As New StringFormat
                string_format.Alignment = StringAlignment.Center
                string_format.LineAlignment = StringAlignment.Center

                ' Translacja do początku, obrót o translacja z powrotem.
                e.Graphics.TranslateTransform(-Me.ClientSize.Width \ 2, -Me.ClientSize.Height \ 2, MatrixOrder.Append)
                e.Graphics.RotateTransform(60, MatrixOrder.Append)
                e.Graphics.TranslateTransform(Me.ClientSize.Width \ 2, Me.ClientSize.Height \ 2, MatrixOrder.Append)

                ' Rysuje tekst i prostokąt rozkładu.
                e.Graphics.TextRenderingHint = System.Drawing.Text.TextRenderingHint.AntiAliasGridFit
                e.Graphics.DrawString(txt, the_font, Brushes.Black, layout_rect, string_format)
                e.Graphics.DrawRectangle(Pens.Black, Rectangle.Round(layout_rect))
            End Using ' string_format
        End Using ' the_font
    End Sub
End Class
