﻿Imports System.Drawing.Drawing2D
Imports System.Math

Public Class Form1
    Private Sub Form1_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles MyBase.Paint
        Dim x As Integer = 10
        Dim y As Integer = 10
        Dim wid As Integer = 100
        Dim hgt As Integer = 50

        ' Wypełnia prostokąt.
        Dim rect_pts() As Point = { _
            New Point(x, y), _
            New Point(x + wid, y), _
            New Point(x + wid, y + hgt), _
            New Point(x, y + hgt) _
        }
        Dim path_brush As New PathGradientBrush(rect_pts)
        e.Graphics.FillPolygon(path_brush, rect_pts)
        y += hgt + 10

        ' Wypełnia elipsę ustawiając CenterColor i SurroundColors.
        Dim ellipse_path As New GraphicsPath
        ellipse_path.AddEllipse(x, y, wid, hgt)
        path_brush = New PathGradientBrush(ellipse_path)
        path_brush.CenterColor = Color.White
        path_brush.SurroundColors = New Color() {Color.Black}
        e.Graphics.FillEllipse(path_brush, x, y, wid, hgt)
        y += hgt + 10

        ' Wypełnia elipsę przy użyciu SetBlendTriangularShape.
        ellipse_path = New GraphicsPath
        ellipse_path.AddEllipse(x, y, wid, hgt)
        path_brush = New PathGradientBrush(ellipse_path)
        path_brush.CenterColor = Color.White
        path_brush.SurroundColors = New Color() {Color.Black}
        path_brush.SetBlendTriangularShape(0.5)
        e.Graphics.FillEllipse(path_brush, x, y, wid, hgt)
        y += hgt + 10

        ' Wypełnia elipsę przy użyciu SetSigmaBellShape.
        ellipse_path = New GraphicsPath
        ellipse_path.AddEllipse(x, y, wid, hgt)
        path_brush = New PathGradientBrush(ellipse_path)
        path_brush.CenterColor = Color.White
        path_brush.SurroundColors = New Color() {Color.Black}
        path_brush.SetSigmaBellShape(0.5, 1)
        e.Graphics.FillEllipse(path_brush, x, y, wid, hgt)
        y += hgt + 10

        ' Wypełnia gwiazdę.
        x += wid + 10
        y = 10
        wid = 150
        hgt = 150
        Dim cx As Integer = x + wid \ 2
        Dim cy As Integer = y + hgt \ 2
        Dim r1 As Integer = CInt(wid * 0.5)
        Dim r2 As Integer = CInt(hgt * 0.25)
        Dim star_pts(9) As Point
        For i As Integer = 0 To 9 Step 2
            star_pts(i).X = cx + CInt(r1 * Cos(i * PI / 5 - PI / 2))
            star_pts(i).Y = cy + CInt(r1 * Sin(i * PI / 5 - PI / 2))
            star_pts(i + 1).X = cx + CInt(r2 * Cos((i + 1) * PI / 5 - PI / 2))
            star_pts(i + 1).Y = cy + CInt(r2 * Sin((i + 1) * PI / 5 - PI / 2))
        Next i
        Dim star_path As New GraphicsPath
        star_path.AddPolygon(star_pts)
        Dim star_brush As New PathGradientBrush(star_pts)
        star_brush.CenterColor = Color.Black
        star_brush.SurroundColors = New Color() { _
            Color.Black, Color.White, _
            Color.Black, Color.White, _
            Color.Black, Color.White, _
            Color.Black, Color.White, _
            Color.Black, Color.White _
        }
        e.Graphics.FillPolygon(star_brush, star_pts)
        y += hgt + 10

        ' Wypełnia gwiazdę.
        cx = x + wid \ 2
        cy = y + hgt \ 2
        r1 = CInt(wid * 0.5)
        r2 = CInt(hgt * 0.25)
        For i As Integer = 0 To 9 Step 2
            star_pts(i).X = cx + CInt(r1 * Cos(i * PI / 5 - PI / 2))
            star_pts(i).Y = cy + CInt(r1 * Sin(i * PI / 5 - PI / 2))
            star_pts(i + 1).X = cx + CInt(r2 * Cos((i + 1) * PI / 5 - PI / 2))
            star_pts(i + 1).Y = cy + CInt(r2 * Sin((i + 1) * PI / 5 - PI / 2))
        Next i
        star_path = New GraphicsPath
        star_path.AddPolygon(star_pts)
        star_brush = New PathGradientBrush(star_pts)
        star_brush.CenterColor = Color.White
        'star_brush.SurroundColors = New Color() { _
        '    Color.Red, Color.Blue, _
        '    Color.Red, Color.Blue, _
        '    Color.Red, Color.Blue, _
        '    Color.Red, Color.Blue, _
        '    Color.Red, Color.Blue _
        '}
        star_brush.SurroundColors = New Color() { _
            Color.White, Color.Black, _
            Color.White, Color.Black, _
            Color.White, Color.Black, _
            Color.White, Color.Black, _
            Color.White, Color.Black _
        }
        Dim star_blend As New Blend
        star_blend.Positions = New Single() {0.0, 0.25, 0.5, 0.75, 1.0}
        star_blend.Factors = New Single() {0.0, 1.0, 0.0, 1.0, 0.0}
        star_brush.Blend = star_blend
        e.Graphics.FillPolygon(star_brush, star_pts)

        ' Rysuje biały obrys, aby pozbyć się 
        ' źle narysowanych pikseli.
        e.Graphics.DrawPolygon(Pens.White, star_pts)

        path_brush.Dispose()
        ellipse_path.Dispose()
        star_brush.Dispose()
        star_path.Dispose()
    End Sub
End Class
