﻿Imports System.ComponentModel
Imports System.Collections.Generic

Public Class PersonNode
    Inherits TreeNode(Of Person)
    Public Sub New(ByVal person_object As Person)
        MyBase.New(person_object)
    End Sub
End Class

Public Class PersonTree
    Inherits Tree(Of Person)
End Class

' You can define and consume generic classes,
' structures, interfaces, procedures, and delegates.
Public Class Tree(Of DataType)
    ' The Root property.
    Private m_Root As PersonNode = Nothing
    <Description("The tree's root node."), _
     Category("Data")> _
    Public Property Root() As PersonNode
        Get
            Return m_Root
        End Get
        Set(ByVal value As PersonNode)
            m_Root = value
        End Set
    End Property

    ' Empty the tree.
    Public Sub Clear()
        m_Root = Nothing
    End Sub

    ' Make a new node to be the tree's root.
    Public Function MakeRoot(ByVal person_item As Person) As PersonNode
        m_Root = New PersonNode(person_item)
        Return m_Root
    End Function

    ' Return a textual representation of the tree.
    Public Overrides Function ToString() As String
        Return m_Root.ToString()
    End Function
End Class

' Store an object with its neighbors.
Public Class TreeNode(Of data_type)
    Public NodeObject As data_type
    Public Children As New List(Of PersonNode)

    ' Initialize the new Node.
    Public Sub New(ByVal node_object As data_type)
        NodeObject = node_object
    End Sub

    ' Add a child to this node's Children list.
    Public Function AddChild(ByVal node_item As Person) As PersonNode
        Dim child_node As New PersonNode(node_item)
        Children.Add(child_node)
        Return child_node
    End Function

    ' Return the subtree's string representation,
    ' suitably indented.
    Public Shadows Function ToString(Optional ByVal indent As Integer = 0) As String
        ' Add this node's text.
        Dim txt As String
        txt = New String(" "c, indent) & NodeObject.ToString & vbCrLf

        ' Add the children's text.
        For Each child As PersonNode In Children
            txt &= child.ToString(indent + 2)
        Next child

        Return txt
    End Function
End Class
