﻿Imports System.Collections.Specialized

Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        Dim dict As New EmployeeListDictionary
        dict.Add("123-45-6789", New Employee("Al", "Ankh"))
        dict.Add("111-22-3333", New Employee("Bertie", "Bithoin"))
        dict.Add("365-76-5476", New Employee("Carl", "Catabalpas"))
        dict.Add("832-77-6847", New Employee("Dee", "Divers"))

        Dim txt As String = ""
        txt &= dict.Item("123-45-6789").ToString & vbCrLf
        txt &= dict.Item("111-22-3333").ToString & vbCrLf
        txt &= dict.Item("365-76-5476").ToString & vbCrLf
        txt &= dict.Item("832-77-6847").ToString & vbCrLf

        txtResults.Text = txt
        txtResults.Select(0, 0)
    End Sub
End Class

Public Class Employee
    Private m_FirstName As String
    Private m_LastName As String
    Public Sub New(ByVal first_name As String, ByVal last_name As String)
        m_FirstName = first_name
        m_LastName = last_name
    End Sub
    Public Overrides Function ToString() As String
        Return m_FirstName & " " & m_LastName
    End Function
End Class

Public Class EmployeeListDictionary
    Inherits ListDictionary

    ' Dodaje wpis do słownika.
    Public Shadows Sub Add(ByVal new_key As String, ByVal new_employee As Employee)
        MyBase.Add(new_key, new_employee)
    End Sub

    ' Zwraca obiekt mający podany klucz.
    Default Public Shadows Property Item(ByVal key As String) As Employee
        Get
            Return DirectCast(MyBase.Item(key), Employee)
        End Get
        Set(ByVal Value As Employee)
            MyBase.Item(key) = Value
        End Set
    End Property

    ' Zwraca True, jeśli słownik zawiera tego pracownika.
    Public Shadows Function Contains(ByVal key As String) As Boolean
        Return MyBase.Contains(key)
    End Function

    ' Usuwa ten wpis.
    Public Shadows Sub Remove(ByVal key As String)
        MyBase.Remove(key)
    End Sub
End Class
