﻿<ToolboxBitmap(GetType(SimpleSmiley), "SmileyFaceTool.bmp")> _
Public Class SimpleSmiley
    Inherits Control

    Private Sub SimpleSmiley_Paint(ByVal sender As Object, _
     ByVal e As System.Windows.Forms.PaintEventArgs) Handles Me.Paint
        DrawFace(e.Graphics)
    End Sub
    Private Sub SimpleSmiley_Resize(ByVal sender As Object, _
     ByVal e As System.EventArgs) Handles Me.Resize
        Me.Invalidate()
    End Sub

    ' Rysuje buźkę.
    Private Sub DrawFace(ByVal gr As Graphics)
        Debug.WriteLine("DrawFace")

        If (Me.ClientSize.Width = 0) Or _
           (Me.ClientSize.Height = 0) Then Exit Sub

        gr.Clear(Me.BackColor)
        gr.SmoothingMode = Drawing2D.SmoothingMode.HighQuality

        ' Buźka.
        Dim face_rect As New Rectangle(0, 0, _
            Me.ClientSize.Width - 1, _
            Me.ClientSize.Height - 1)
        gr.FillEllipse(Brushes.Yellow, face_rect)
        gr.DrawEllipse(Pens.Black, face_rect)

        ' Uśmiech.
        Dim smile_rect As New Rectangle( _
            CInt(Me.ClientSize.Width * 0.15), _
            CInt(Me.ClientSize.Height * 0.15), _
            CInt(Me.ClientSize.Width * 0.7), _
            CInt(Me.ClientSize.Height * 0.7))
        gr.DrawArc(Pens.Black, _
            smile_rect, 20, 140)

        ' Oczy.
        Dim eye_rect As New Rectangle( _
            CInt(Me.ClientSize.Width * 0.2), _
            CInt(Me.ClientSize.Height * 0.2), _
            CInt(Me.ClientSize.Width * 0.2), _
            CInt(Me.ClientSize.Height * 0.25))
        gr.FillEllipse(Brushes.White, eye_rect)
        gr.DrawEllipse(Pens.Black, eye_rect)
        Dim pupil_rect As New Rectangle( _
            CInt(Me.ClientSize.Width * 0.3), _
            CInt(Me.ClientSize.Height * 0.3), _
            CInt(Me.ClientSize.Width * 0.1), _
            CInt(Me.ClientSize.Height * 0.125))
        gr.FillEllipse(Brushes.Black, pupil_rect)

        eye_rect.Offset(CInt(Me.ClientSize.Width * 0.4), 0)
        gr.FillEllipse(Brushes.White, eye_rect)
        gr.DrawEllipse(Pens.Black, eye_rect)
        pupil_rect.Offset(CInt(Me.ClientSize.Width * 0.4), 0)
        gr.FillEllipse(Brushes.Black, pupil_rect)

        ' Nos.
        Dim nose_rect As New Rectangle( _
            CInt(Me.ClientSize.Width * 0.4), _
            CInt(Me.ClientSize.Height * 0.45), _
            CInt(Me.ClientSize.Width * 0.2), _
            CInt(Me.ClientSize.Height * 0.25))
        gr.FillEllipse(Brushes.Green, nose_rect)
        gr.DrawEllipse(Pens.Black, nose_rect)
    End Sub
End Class
