﻿Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        Dim customers As New List(Of Person)
        customers.Add(New Person() With {.FirstName = "Ben", .LastName = "Best", .CustId = 2})
        customers.Add(New Person() With {.FirstName = "Frank", .LastName = "Fix", .CustId = 4})
        customers.Add(New Person() With {.FirstName = "Ann", .LastName = "Archer", .CustId = 5})
        customers.Add(New Person() With {.FirstName = "Edna", .LastName = "Ever", .CustId = 3})
        customers.Add(New Person() With {.FirstName = "Carly", .LastName = "Cant", .CustId = 6})
        customers.Add(New Person() With {.FirstName = "Dan", .LastName = "Dump", .CustId = 1})

        Dim orders As New List(Of Order)
        orders.Add(New Order() With {.CustId = 1, .OrderId = 103})
        orders.Add(New Order() With {.CustId = 1, .OrderId = 101})
        orders.Add(New Order() With {.CustId = 3, .OrderId = 102})
        orders.Add(New Order() With {.CustId = 1, .OrderId = 104})
        orders.Add(New Order() With {.CustId = 2, .OrderId = 106})
        orders.Add(New Order() With {.CustId = 2, .OrderId = 100})
        orders.Add(New Order() With {.CustId = 2, .OrderId = 105})
        orders.Add(New Order() With {.CustId = 3, .OrderId = 107})

        Dim order_items As New List(Of OrderItem)
        order_items.Add(New OrderItem() With {.OrderId = 103, .Description = "Blue"})
        order_items.Add(New OrderItem() With {.OrderId = 103, .Description = "Dun"})
        order_items.Add(New OrderItem() With {.OrderId = 103, .Description = "Cerise"})
        order_items.Add(New OrderItem() With {.OrderId = 103, .Description = "Argent"})
        order_items.Add(New OrderItem() With {.OrderId = 100, .Description = "Apple"})
        order_items.Add(New OrderItem() With {.OrderId = 100, .Description = "Cherry"})
        order_items.Add(New OrderItem() With {.OrderId = 102, .Description = "Ash"})
        order_items.Add(New OrderItem() With {.OrderId = 101, .Description = "Cat"})
        order_items.Add(New OrderItem() With {.OrderId = 102, .Description = "Beech"})
        order_items.Add(New OrderItem() With {.OrderId = 101, .Description = "Bat"})
        order_items.Add(New OrderItem() With {.OrderId = 100, .Description = "Banana"})
        order_items.Add(New OrderItem() With {.OrderId = 101, .Description = "Dog"})
        order_items.Add(New OrderItem() With {.OrderId = 102, .Description = "Choke Cherry"})
        order_items.Add(New OrderItem() With {.OrderId = 101, .Description = "Ape"})
        order_items.Add(New OrderItem() With {.OrderId = 105, .Description = "Ace"})
        order_items.Add(New OrderItem() With {.OrderId = 104, .Description = "Ball"})
        order_items.Add(New OrderItem() With {.OrderId = 104, .Description = "Axe"})
        order_items.Add(New OrderItem() With {.OrderId = 104, .Description = "Club"})
        order_items.Add(New OrderItem() With {.OrderId = 106, .Description = "Airplane"})
        order_items.Add(New OrderItem() With {.OrderId = 107, .Description = "Air"})

        Dim txt As String = ""
        txt &= "*** q1 ***" & vbCrLf
        Dim q1 = From per In customers _
            Where per.LastName > "C" _
            Order By per.CustId _
            Select per
        For Each per As Person In q1
            txt &= per.ToString() & vbCrLf
        Next per

        txt &= vbCrLf & "*** q2 ***" & vbCrLf
        Dim q2 = From ord In orders _
            Group By ord.CustId Into CustOrders = Group, Count() _
            Order By CustId
        For Each g In q2
            txt &= g.Count & " orders for customer " & g.CustId & ":" & vbCrLf
            Dim order_info = g.CustOrders
            For Each o In order_info
                txt &= Space$(4) & o.ToString & vbCrLf
            Next o
        Next g

        txt &= vbCrLf & "*** q3 ***" & vbCrLf
        Dim q3 = From ord_item In order_items, ord In orders, cust In customers _
            Where cust.CustId = ord.CustId AndAlso _
                  ord.OrderId = ord_item.OrderId _
            Select New With {cust.CustId, ord.OrderId, ord_item.Description}
        For Each v In q3
            'txt &= "CustId: " & v.CustId & ", OrderId: " & v.OrderId & ", Description: " & v.Description & vbCrLf
        Next v

        txt &= vbCrLf & "*** q4 ***" & vbCrLf
        Dim q4 = From cust In customers, ord In orders, ord_item In order_items _
            Where cust.CustId = ord.CustId AndAlso ord.OrderId = ord_item.OrderId _
            Group By cust.CustId Into CustGroups = Group _
            Select New With {CustId, _
                .CustOrders = _
                    From cust_group In CustGroups _
                    Group By cust_group.ord.OrderId Into CustOrds = Group}
        For Each c In q4
            txt &= "Customer: " & c.CustId & vbCrLf
            For Each o In c.CustOrders
                txt &= Space$(4) & "OrderId: " & o.OrderId & vbCrLf
                For Each oi In o.CustOrds
                    txt &= Space$(8) & "Item: " & oi.ord_item.Description & vbCrLf
                Next oi
            Next o
        Next c

        txt &= vbCrLf & "*** q5 ***" & vbCrLf
        'Dim q5 = From cust In customers, ord In orders, ord_item In order_items _
        '    Where cust.CustId = ord.CustId AndAlso ord.OrderId = ord_item.OrderId _
        '    Order By cust.CustId, ord.OrderId, ord_item.Description '  _
        Dim q5 = From cust In customers, ord In orders, ord_item In order_items _
            Where cust.CustId = ord.CustId AndAlso ord.OrderId = ord_item.OrderId _
            Order By cust.CustId, ord.OrderId, ord_item.Description _
            Group By cust.CustId Into CustomerOrders = Group _
            Select New With { _
                CustId, .CustOrders = _
                    From cust_orders In CustomerOrders _
                    Group By cust_orders.ord.OrderId Into OrderIdGroup = Group _
                    Select New With { _
                        OrderId, CustomerOrders, .OrderDetail = From oi In OrderIdGroup _
                    } _
            }

        For Each c In q5
            txt &= "Customer: " & c.CustId & vbCrLf
            For Each o In c.CustOrders
                txt &= Space$(4) & "OrderId: " & o.OrderId & vbCrLf
                For Each oi In o.OrderDetail
                    txt &= Space$(8) & "Item: " & oi.ord_item.Description & vbCrLf
                Next oi
            Next o
        Next c

        ' Przykład rekursywnej funkcji lambda.
        'Dim factorial As Func(Of Double, Double) = Nothing
        'factorial = Function(x As Double) If(x <= 1, 1, x * factorial(x - 1))
        'MessageBox.Show("5! = " & factorial(5), "Factorial", MessageBoxButtons.OK)

        '@ Dim factorial = Function(x As Double) If(x <= 1, 1, x * factorial(x - 1))

        TextBox1.Text = txt
        TextBox1.Select(0, 0)
    End Sub
End Class

Public Class Person
    Public FirstName As String
    Public LastName As String
    Public CustId As Integer
    Public Overrides Function ToString() As String
        Return FirstName & " " & LastName & " (" & CustId & ")"
    End Function
End Class

Public Class Order
    Public CustId As Integer
    Public OrderDate As Date
    Public OrderId As Integer
    Public Overrides Function ToString() As String
        Return "CustId: " & CustId & ", OrderId: " & OrderId & ", Date: " & OrderDate
    End Function
End Class

Public Class OrderItem
    Public OrderId As Integer
    Public Description As String
    Public Overrides Function ToString() As String
        Return "OrderId: " & OrderId & ", Opis: " & Description
    End Function
End Class
