﻿Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        ' Tworzenie danych.
        Dim all_customers As New List(Of Person)
        all_customers.Add(New Person() With {.FirstName = "Ben", .LastName = "Best", .CustId = 2})
        all_customers.Add(New Person() With {.FirstName = "Frank", .LastName = "Fix", .CustId = 4})
        all_customers.Add(New Person() With {.FirstName = "Ann", .LastName = "Archer", .CustId = 5})
        all_customers.Add(New Person() With {.FirstName = "Edna", .LastName = "Ever", .CustId = 3})
        all_customers.Add(New Person() With {.FirstName = "Carly", .LastName = "Cant", .CustId = 6})
        all_customers.Add(New Person() With {.FirstName = "Dan", .LastName = "Dump", .CustId = 1})

        Dim all_orders As New List(Of Order)
        all_orders.Add(New Order() With {.CustId = 1, .OrderId = 103, .OrderDate = #4/12/2008#})
        all_orders.Add(New Order() With {.CustId = 1, .OrderId = 101, .OrderDate = #4/4/2008#})
        all_orders.Add(New Order() With {.CustId = 3, .OrderId = 102, .OrderDate = #4/7/2008#})
        all_orders.Add(New Order() With {.CustId = 1, .OrderId = 104, .OrderDate = #4/15/2008#})
        all_orders.Add(New Order() With {.CustId = 2, .OrderId = 106, .OrderDate = #4/23/2008#})
        all_orders.Add(New Order() With {.CustId = 2, .OrderId = 100, .OrderDate = #4/7/2008#})
        all_orders.Add(New Order() With {.CustId = 2, .OrderId = 105, .OrderDate = #4/19/2008#})
        all_orders.Add(New Order() With {.CustId = 3, .OrderId = 107, .OrderDate = #4/29/2008#})
        all_orders.Add(New Order() With {.CustId = 4, .OrderId = 108, .OrderDate = #5/2/2008#})
        all_orders.Add(New Order() With {.CustId = 5, .OrderId = 109, .OrderDate = #5/11/2008#})
        all_orders.Add(New Order() With {.CustId = 6, .OrderId = 110, .OrderDate = #5/15/2008#})

        Dim all_order_items As New List(Of OrderItem)
        all_order_items.Add(New OrderItem() With {.OrderId = 100, .Description = "Notebook", .UnitPrice = 2.5, .Quantity = 6})
        all_order_items.Add(New OrderItem() With {.OrderId = 100, .Description = "Pen, dozen", .UnitPrice = 2.65, .Quantity = 12})
        all_order_items.Add(New OrderItem() With {.OrderId = 100, .Description = "Banana", .UnitPrice = 2.2, .Quantity = 1})
        all_order_items.Add(New OrderItem() With {.OrderId = 101, .Description = "Cookie", .UnitPrice = 1.25, .Quantity = 144})
        all_order_items.Add(New OrderItem() With {.OrderId = 101, .Description = "Notebook", .UnitPrice = 2.5, .Quantity = 6})
        all_order_items.Add(New OrderItem() With {.OrderId = 101, .Description = "Pen, dozen", .UnitPrice = 2.65, .Quantity = 12})
        all_order_items.Add(New OrderItem() With {.OrderId = 101, .Description = "Soda", .UnitPrice = 0.75, .Quantity = 4})
        all_order_items.Add(New OrderItem() With {.OrderId = 102, .Description = "Paper, ream", .UnitPrice = 3.5, .Quantity = 6})
        all_order_items.Add(New OrderItem() With {.OrderId = 102, .Description = "Pen, dozen", .UnitPrice = 2.65, .Quantity = 2})
        all_order_items.Add(New OrderItem() With {.OrderId = 102, .Description = "Notebook", .UnitPrice = 2.5, .Quantity = 6})
        all_order_items.Add(New OrderItem() With {.OrderId = 103, .Description = "Apple", .UnitPrice = 0.75, .Quantity = 6})
        all_order_items.Add(New OrderItem() With {.OrderId = 103, .Description = "Bean, Can", .UnitPrice = 1.15, .Quantity = 6})
        all_order_items.Add(New OrderItem() With {.OrderId = 103, .Description = "Cookie", .UnitPrice = 1.25, .Quantity = 3})
        all_order_items.Add(New OrderItem() With {.OrderId = 103, .Description = "Pencil, dozen", .UnitPrice = 1.35, .Quantity = 4})
        all_order_items.Add(New OrderItem() With {.OrderId = 104, .Description = "Notebook", .UnitPrice = 2.5, .Quantity = 2})
        all_order_items.Add(New OrderItem() With {.OrderId = 104, .Description = "Flamethrower", .UnitPrice = 1750, .Quantity = 1})
        all_order_items.Add(New OrderItem() With {.OrderId = 104, .Description = "Notebook", .UnitPrice = 2.5, .Quantity = 4})
        all_order_items.Add(New OrderItem() With {.OrderId = 105, .Description = "Paper, ream", .UnitPrice = 3.5, .Quantity = 10})
        all_order_items.Add(New OrderItem() With {.OrderId = 106, .Description = "Notebook", .UnitPrice = 2.5, .Quantity = 2})
        all_order_items.Add(New OrderItem() With {.OrderId = 107, .Description = "Pen, dozen", .UnitPrice = 2.65, .Quantity = 1})
        all_order_items.Add(New OrderItem() With {.OrderId = 108, .Description = "Cookie", .UnitPrice = 1.25, .Quantity = 3})
        all_order_items.Add(New OrderItem() With {.OrderId = 108, .Description = "Pencil, dozen", .UnitPrice = 1.35, .Quantity = 4})
        all_order_items.Add(New OrderItem() With {.OrderId = 109, .Description = "Notebook", .UnitPrice = 2.5, .Quantity = 6})
        all_order_items.Add(New OrderItem() With {.OrderId = 109, .Description = "Pen, dozen", .UnitPrice = 2.65, .Quantity = 12})
        all_order_items.Add(New OrderItem() With {.OrderId = 109, .Description = "Soda", .UnitPrice = 0.75, .Quantity = 4})
        all_order_items.Add(New OrderItem() With {.OrderId = 110, .Description = "Paper, ream", .UnitPrice = 3.5, .Quantity = 6})

        ' Wybór zamówień i agregatów ich elementów.
        Dim query1 = From ord In all_orders, ord_item In all_order_items _
            Order By ord.CustId, ord.OrderId _
            Where ord.OrderId = ord_item.OrderId _
            Group ord_item By ord Into _
                TheAverage = Average(ord_item.UnitPrice * ord_item.Quantity), _
                TheCount = Count(ord_item.UnitPrice * ord_item.Quantity), _
                TheLongCount = LongCount(ord_item.UnitPrice * ord_item.Quantity), _
                TheMax = Max(ord_item.UnitPrice * ord_item.Quantity), _
                TheMin = Min(ord_item.UnitPrice * ord_item.Quantity), _
                TheSum = Sum(ord_item.Quantity * ord_item.UnitPrice)
        For Each obj In query1
            ' Wyświetlenie informacji o zamówieniu.
            Dim list_item As ListViewItem = lvwResults.Items.Add(obj.ord.OrderId)
            list_item.SubItems.Add(FormatCurrency(obj.TheAverage.ToString(FormatCurrency("0.00"))))
            list_item.SubItems.Add(obj.TheCount)
            list_item.SubItems.Add(obj.TheLongCount)
            list_item.SubItems.Add(FormatCurrency(obj.TheMax))
            list_item.SubItems.Add(FormatCurrency(obj.TheMin))
            list_item.SubItems.Add(FormatCurrency(obj.TheSum))
        Next obj
    End Sub
End Class

Public Class Person
    Public FirstName As String
    Public LastName As String
    Public CustId As Integer
    Public Overrides Function ToString() As String
        Return FirstName & " " & LastName & " (" & CustId & ")"
    End Function
End Class

Public Class Order
    Public CustId As Integer
    Public OrderDate As Date
    Public OrderId As Integer
    Public Overrides Function ToString() As String
        Return "CustId: " & CustId & ", OrderId: " & OrderId & ", Date: " & OrderDate
    End Function
End Class

Public Class OrderItem
    Public OrderId As Integer
    Public Description As String
    Public UnitPrice As Decimal
    Public Quantity As Integer
    Public Overrides Function ToString() As String
        Return "OrderId: " & OrderId & ", Description: " & Description
    End Function
End Class
