﻿Public Class Form1
    ' Źródło danych.
    Private m_ContactsTable As DataTable

    ' Obiekt CurrencyManager źródła danych.
    Private WithEvents m_CurrencyManager As CurrencyManager

    Private Sub Form1_Load() Handles MyBase.Load
        ' Utworzenie DataTable.
        m_ContactsTable = New DataTable("Contacts")

        ' Dodanie kolumn.
        m_ContactsTable.Columns.Add("FirstName", GetType(String))
        m_ContactsTable.Columns.Add("LastName", GetType(String))
        m_ContactsTable.Columns.Add("Street", GetType(String))
        m_ContactsTable.Columns.Add("City", GetType(String))
        m_ContactsTable.Columns.Add("State", GetType(String))
        m_ContactsTable.Columns.Add("Zip", GetType(String))

        ' Pary FirstName-LastName muszą być unikatowe.
        Dim first_last_columns() As DataColumn = { _
            m_ContactsTable.Columns("FirstName"), _
            m_ContactsTable.Columns("LastName") _
        }
        m_ContactsTable.Constraints.Add( _
            New UniqueConstraint(first_last_columns))

        ' Dane kontaktowe.
        m_ContactsTable.Rows.Add(New Object() {"Art", "Ant", _
            "1234 Ash Pl", "Bugville", "CO", "11111"})
        m_ContactsTable.Rows.Add(New Object() {"Bev", "Bug", _
            "22 Beach St", "Bugville", "CO", "22222"})
        m_ContactsTable.Rows.Add(New Object() {"Cid", "Cat", _
            "3 Road Place Lane", "Programmeria", "KS", "33333"})
        m_ContactsTable.Rows.Add(New Object() {"Deb", "Dove", _
            "414 Debugger Way", "Programmeria", "KS", "44444"})
        m_ContactsTable.Rows.Add(New Object() {"Ed", "Eager", _
            "5746 Elm Blvd", "Bugville", "CO", "55555"})
        m_ContactsTable.Rows.Add(New Object() {"Fran", "Fix", _
            "647 Foxglove Ct", "Bugville", "CO", "66666"})
        m_ContactsTable.Rows.Add(New Object() {"Gus", "Gantry", _
            "71762-B Gooseberry Ave", "Programmeria", "KS", "77777"})
        m_ContactsTable.Rows.Add(New Object() {"Hil", "Harris", _
            "828 Hurryup St", "Programmeria", "KS", "88888"})

        ' Wiązanie z kontrolkami.
        txtFirstName.DataBindings.Add("Text", m_ContactsTable, "FirstName")
        txtLastName.DataBindings.Add("Text", m_ContactsTable, "LastName")
        txtStreet.DataBindings.Add("Text", m_ContactsTable, "Street")
        txtCity.DataBindings.Add("Text", m_ContactsTable, "City")
        txtState.DataBindings.Add("Text", m_ContactsTable, "State")
        txtZip.DataBindings.Add("Text", m_ContactsTable, "Zip")

        ' Zapisanie referencji do CurrencyManager.
        m_CurrencyManager = _
            DirectCast(Me.BindingContext(m_ContactsTable), CurrencyManager)

        ' Wyświetlenie pozycji pierwszego rekordu.
        m_CurrencyManager_PositionChanged()
    End Sub

    Private Sub btnFirst_Click() Handles btnFirst.Click
        m_CurrencyManager.Position = 0
    End Sub

    Private Sub btnPrev_Click() Handles btnPrev.Click
        m_CurrencyManager.Position -= 1
    End Sub

    Private Sub btnNext_Click() Handles btnNext.Click
        m_CurrencyManager.Position += 1
    End Sub

    Private Sub btnLast_Click() Handles btnLast.Click
        m_CurrencyManager.Position = m_CurrencyManager.Count - 1
    End Sub

    ' Dodanie nowego rekordu.
    Private Sub btnAdd_Click() Handles btnAdd.Click
        m_CurrencyManager.AddNew()
    End Sub

    ' Usunięcie bieżącego rekordu.
    Private Sub btnDelete_Click() Handles btnDelete.Click
        If MsgBox("Czy na pewno chcesz usunąć ten rekord?", _
            MsgBoxStyle.Question Or MsgBoxStyle.YesNo, _
            "Potwierdzenie") = MsgBoxResult.Yes _
        Then
            m_CurrencyManager.RemoveAt(m_CurrencyManager.Position)
            m_CurrencyManager_PositionChanged()
        End If
    End Sub

    ' Wyświetlenie bieżącej pozycji CurrencyManager.
    Private Sub m_CurrencyManager_PositionChanged() Handles m_CurrencyManager.PositionChanged
        lblPosition.Text = _
            "Rekord " & _
            m_CurrencyManager.Position + 1 & _
            " z " & _
            m_CurrencyManager.Count
    End Sub
End Class
