﻿Public Class Form1
    Private Sub btnGo_Click() Handles btnGo.Click
        Dim X, Y As Complex
        X = New Complex(Double.Parse(txtXr.Text), Double.Parse(txtXi.Text))
        Y = New Complex(Double.Parse(txtYr.Text), Double.Parse(txtYi.Text))

        lblXplusY.Text = (X + Y).ToString
        lblXminusY.Text = (X - Y).ToString
        lblXtimesY.Text = (X * Y).ToString
        lblXeqY.Text = (X = Y).ToString
        lblXneY.Text = (X <> Y).ToString
        lblNegX.Text = (-X).ToString
        Dim abs_x As Double = CDbl(X)
        lblAbsX.Text = abs_x.ToString
    End Sub
End Class

Public Class Complex
    Public Re As Double
    Public Im As Double

    ' Konstruktory.
    Public Sub New()
    End Sub
    Public Sub New(ByVal real_part As Double, ByVal imaginary_part As Double)
        Re = real_part
        Im = imaginary_part
    End Sub

    ' ToString.
    Public Overrides Function ToString() As String
        Dim txt As String = Re.ToString
        If Im < 0 Then
            txt &= " - " & Math.Abs(Im).ToString
        Else
            txt &= " + " & Im.ToString
        End If
        Return txt & "i"
    End Function

    ' Operatory.
    Public Shared Operator *(ByVal c1 As Complex, ByVal c2 As Complex) As Complex
        Return New Complex( _
            c1.Re * c2.Re - c1.Im * c2.Im, _
            c1.Re * c2.Im + c1.Im * c2.Re)
    End Operator
    Public Shared Operator +(ByVal c1 As Complex, ByVal c2 As Complex) As Complex
        Return New Complex( _
            c1.Re + c2.Re, _
            c1.Im + c2.Im)
    End Operator
    Public Shared Operator -(ByVal c1 As Complex, ByVal c2 As Complex) As Complex
        Return New Complex( _
            c1.Re - c2.Re, _
            c1.Im - c2.Im)
    End Operator
    Public Shared Operator =(ByVal c1 As Complex, ByVal c2 As Complex) As Boolean
        Return (c1.Re = c2.Re) AndAlso (c1.Im = c2.Im)
    End Operator
    Public Shared Operator <>(ByVal c1 As Complex, ByVal c2 As Complex) As Boolean
        Return (c1.Re <> c2.Re) OrElse (c1.Im <> c2.Im)
    End Operator
    Public Shared Operator -(ByVal c1 As Complex) As Complex
        Return New Complex(-c1.Re, -c1.Im)
    End Operator
    Public Shared Narrowing Operator CType(ByVal c1 As Complex) As Double
        Return System.Math.Sqrt(c1.Re * c1.Re + c1.Im * c1.Im)
    End Operator
End Class
