﻿Imports System.IO

Public Class MruList
    Private m_ApplicationName As String
    Private m_FileMenu As ToolStripMenuItem
    Private m_NumEntries As Integer
    Private m_FileNames As Collection
    Private m_MenuItems As Collection

    Public Event OpenFile(ByVal file_name As String)

    Public Sub New(ByVal application_name As String, ByVal file_menu As ToolStripMenuItem, ByVal num_entries As Integer)
        m_ApplicationName = application_name
        m_FileMenu = file_menu
        m_NumEntries = num_entries
        m_FileNames = New Collection
        m_MenuItems = New Collection

        ' Załadowanie zapisanych nazw plików z rejestru.
        LoadMruList()

        ' Wyświetlenie listy MRU.
        DisplayMruList()
    End Sub

    ' Załadowanie wcześniej zapisanych nazw plików z rejestru.
    Private Sub LoadMruList()
        Dim file_name As String
        For i As Integer = 1 To m_NumEntries
            ' Pobranie następnej nazwy pliku o tytułu.
            file_name = GetSetting(m_ApplicationName, _
                "MruList", "FileName" & i, "")

            ' Sprawdzenie czy coś jest.
            If file_name.Length > 0 Then
                ' Zapisanie nazwy pliku.
                m_FileNames.Add(file_name, file_name)
            End If
        Next i
    End Sub

    ' Zapisanie listy MRU w rejestrze.
    Private Sub SaveMruList()
        ' Usunięcie poprzednich wpisów.
        If GetSetting(m_ApplicationName, "MruList", _
         "FileName1", "").Length > 0 Then
            DeleteSetting(m_ApplicationName, "MruList")
        End If

        ' Utworzenie nowych wpisów.
        For i As Integer = 1 To m_FileNames.Count
            SaveSetting(m_ApplicationName, _
                "MruList", "FileName" & i, _
                m_FileNames(i).ToString)
        Next i
    End Sub

    ' Wyświetlenie listy MRU.
    Private Sub DisplayMruList()
        ' Usunięcie starych elementów menu z menu Plik.
        For Each mnu As ToolStripItem In m_MenuItems
            m_FileMenu.DropDownItems.Remove(mnu)
        Next mnu
        m_MenuItems = New Collection

        ' Sprawdzenie czy są jakieś nazwy plików.
        If m_FileNames.Count > 0 Then
            ' Utworzenie separatora.
            Dim sep As New ToolStripSeparator()
            m_MenuItems.Add(sep)
            m_FileMenu.DropDownItems.Add(sep)

            ' Utworzenie innych elementów menu.
            Dim mnu As ToolStripMenuItem
            For i As Integer = 1 To m_FileNames.Count
                mnu = New ToolStripMenuItem()
                mnu.Text = "&" & i & " " & _
                    New FileInfo(m_FileNames(i).ToString).Name
                AddHandler mnu.Click, AddressOf MruItem_Click
                m_MenuItems.Add(mnu)
                m_FileMenu.DropDownItems.Add(mnu)
            Next i
        End If
    End Sub

    ' Procedura obsługi elementów menu MRU.
    Private Sub MruItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        Dim mnu As ToolStripMenuItem
        mnu = DirectCast(sender, ToolStripMenuItem)

        ' Znajduje element menu, który zgłosił to zdarzenie.
        For i As Integer = 1 To m_FileNames.Count
            ' Sprawdzenie czy to jest ten element. (Dodanie 1 dla separatora.)
            If m_MenuItems(i + 1) Is mnu Then
                ' To jest ten element. Zgłoszenie zdarzenia OpenFile 
                ' dla jego nazwy pliku.
                RaiseEvent OpenFile(m_FileNames(i).ToString)
                Exit For
            End If
        Next i
    End Sub

    ' Dodanie pliku do listy MRU.
    Public Sub Add(ByVal file_name As String)
        ' Usunięcie tego pliku z listy MRU,
        ' jeśli na niej jest.
        Dim i As Integer = FileNameIndex(file_name)
        If i > 0 Then m_FileNames.Remove(i)

        ' Dodanie elementu na początku listy.
        If m_FileNames.Count > 0 Then
            m_FileNames.Add(file_name, file_name, m_FileNames.Item(1))
        Else
            m_FileNames.Add(file_name, file_name)
        End If

        ' Jeśli lista zrobiła się za długa, usuwa ostatni element.
        If m_FileNames.Count > m_NumEntries Then
            m_FileNames.Remove(m_NumEntries + 1)
        End If

        ' Wyświetlenie listy.
        DisplayMruList()

        ' Zapisanie zaktualizowanej listy.
        SaveMruList()
    End Sub

    ' Zwraca indeks pliku na liście.
    Private Function FileNameIndex(ByVal file_name As String) As Integer
        For i As Integer = 1 To m_FileNames.Count
            If m_FileNames(i).ToString = file_name Then Return i
        Next i
        Return 0
    End Function

    ' Usuwa plik z listy MRU.
    Public Sub Remove(ByVal file_name As String)
        ' Sprawdza czy plik jest obecny.
        Dim i As Integer = FileNameIndex(file_name)
        If i > 0 Then
            ' Zwraca ten plik.
            m_FileNames.Remove(i)

            ' Wyświetla listę.
            DisplayMruList()

            ' Zapisuje zaktualizowaną listę.
            SaveMruList()
        End If
    End Sub
End Class