﻿Imports System.Runtime.InteropServices

Public Class Form1
    Public Structure Rect
        Public left As Integer
        Public top As Integer
        Public right As Integer
        Public bottom As Integer
    End Structure

    Protected Overrides Sub WndProc(ByRef m As System.Windows.Forms.Message)
        Const WM_SIZING As Long = &H214
        Const WMSZ_LEFT As Integer = 1
        Const WMSZ_RIGHT As Integer = 2
        Const WMSZ_TOP As Integer = 3
        Const WMSZ_TOPLEFT As Integer = 4
        Const WMSZ_TOPRIGHT As Integer = 5
        Const WMSZ_BOTTOM As Integer = 6
        Const WMSZ_BOTTOMLEFT As Integer = 7
        Const WMSZ_BOTTOMRIGHT As Integer = 8
        Static fixed_aspect_ratio As Double = 0

        Dim new_aspect_ratio As Double

        If m.Msg = WM_SIZING And m.HWnd.Equals(Me.Handle) Then
            ' Zamienia lParam komunikatu na Rect.
            Dim r As Rect
            r = DirectCast( _
                Marshal.PtrToStructure(m.LParam, GetType(Rect)),  _
                Rect)

            ' Pobiera aktualne wymiary.
            Dim wid As Double = r.right - r.left
            Dim hgt As Double = r.bottom - r.top

            ' Pobiera nowy współczynnik proporcji.
            new_aspect_ratio = hgt / wid

            ' Za pierwszym razem zapisuje współczynnik proporcji formularza.
            If fixed_aspect_ratio = 0 Then
                fixed_aspect_ratio = new_aspect_ratio
            End If

            ' Sprawdzenie czy współczynnik proporcji się nie zmienia.
            If fixed_aspect_ratio <> new_aspect_ratio Then
                ' Aby zdecydować, który wymiar zachować,
                ' należy sprawdzić, którą krawędź przeciąga użytkownik.
                If m.WParam.ToInt32 = WMSZ_TOPLEFT Or _
                   m.WParam.ToInt32 = WMSZ_TOPRIGHT Or _
                   m.WParam.ToInt32 = WMSZ_BOTTOMLEFT Or _
                   m.WParam.ToInt32 = WMSZ_BOTTOMRIGHT _
                Then
                    ' Użytkownik przeciąga róg. 
                    ' Zachowuje większy wymiar.
                    If new_aspect_ratio > fixed_aspect_ratio Then
                        ' Za wysoki i cienki. Poszerzanie.
                        wid = hgt / fixed_aspect_ratio
                    Else
                        ' Za krótki i szeroki. Wydłużanie.
                        hgt = wid * fixed_aspect_ratio
                    End If
                ElseIf m.WParam.ToInt32 = WMSZ_LEFT Or _
                       m.WParam.ToInt32 = WMSZ_RIGHT _
                Then
                    ' Użytkownik przeciąga bok. 
                    ' Zachowanie szerokości.
                    hgt = wid * fixed_aspect_ratio
                ElseIf m.WParam.ToInt32 = WMSZ_TOP Or _
                       m.WParam.ToInt32 = WMSZ_BOTTOM _
                Then
                    ' Użytkownik przeciąga górną lub dolną krawędź. 
                    ' Zachowanie wysokości.
                    wid = hgt / fixed_aspect_ratio
                End If

                ' Sprawdzenie czy zresetować góra-dół i
                ' lewy-prawy.
                ' Sprawdzenie czy użytkownik przeciąga górną krawędź.
                If m.WParam.ToInt32 = WMSZ_TOP Or _
                   m.WParam.ToInt32 = WMSZ_TOPLEFT Or _
                   m.WParam.ToInt32 = WMSZ_TOPRIGHT _
                Then
                    ' Resetowanie góry.
                    r.top = r.bottom - CInt(hgt)
                Else
                    ' Resetowanie dołu.
                    r.bottom = r.top + CInt(hgt)
                End If

                ' Sprawdzenie czy użytkownik przeciąga lewą krawędź.
                If m.WParam.ToInt32 = WMSZ_LEFT Or _
                   m.WParam.ToInt32 = WMSZ_TOPLEFT Or _
                   m.WParam.ToInt32 = WMSZ_BOTTOMLEFT _
                Then
                    ' Resetowanie lewej.
                    r.left = r.right - CInt(wid)
                Else
                    ' Resetowanie prawej.
                    r.right = r.left + CInt(wid)
                End If

                ' Aktualizacja pola LParam obiektu Message.
                Marshal.StructureToPtr(r, m.LParam, True)
            End If
        End If

        MyBase.WndProc(m)
    End Sub
End Class
