﻿Public Class Form1
    Private Sub btnColor_Click() Handles btnColor.Click
        ColorDialog1.Color = Me.BackColor
        If ColorDialog1.ShowDialog() = Windows.Forms.DialogResult.OK Then
            Me.BackColor = ColorDialog1.Color
        End If
    End Sub

    Private m_Folder As String = ""
    Private Sub btnFolder_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnFolder.Click
        If m_Folder.Length > 0 Then FolderBrowserDialog1.SelectedPath = m_Folder
        If FolderBrowserDialog1.ShowDialog = Windows.Forms.DialogResult.OK Then
            m_Folder = FolderBrowserDialog1.SelectedPath
            MessageBox.Show("Folder: " & m_Folder, "Ok", MessageBoxButtons.OK, MessageBoxIcon.Information)
        End If
    End Sub

    Private Sub btnFont_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnFont.Click
        FontDialog1.Font = Me.Font
        If FontDialog1.ShowDialog = Windows.Forms.DialogResult.OK Then
            Me.Font = FontDialog1.Font
        End If
    End Sub

    Private m_OpenFile As String = ""
    Private Sub btnOpenFile_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnOpenFile.Click
        If m_OpenFile.Length > 0 Then OpenFileDialog1.FileName = m_OpenFile
        If OpenFileDialog1.ShowDialog = Windows.Forms.DialogResult.OK Then
            m_OpenFile = OpenFileDialog1.FileName
            MessageBox.Show("Otwórz plik: " & m_OpenFile, "Ok", MessageBoxButtons.OK, MessageBoxIcon.Information)
        End If
    End Sub

    Private Sub btnPageSetup_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPageSetup.Click
        PageSetupDialog1.ShowDialog()
    End Sub

    ' Uwaga: PrintDocument1 is ustawiany w czasie projektowania jako własność Document okien
    ' PageSetupDialog1, PrintDialog1 oraz PrintPreviewDialog1.
    Private Sub PrintDocument1_PrintPage(ByVal sender As System.Object, ByVal e As System.Drawing.Printing.PrintPageEventArgs) Handles PrintDocument1.PrintPage
        Using the_pen As New Pen(Color.Red, 10)
            e.Graphics.DrawEllipse(the_pen, e.MarginBounds)
        End Using
    End Sub

    Private Sub btnPrint_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPrint.Click
        PrintDialog1.ShowDialog()
    End Sub

    Private Sub btnPrintPreview_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPrintPreview.Click
        PrintPreviewDialog1.ShowDialog()
    End Sub

    Private m_SaveFile As String = ""
    Private Sub btnSaveFile_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSaveFile.Click
        If m_SaveFile.Length > 0 Then SaveFileDialog1.FileName = m_SaveFile
        If SaveFileDialog1.ShowDialog = Windows.Forms.DialogResult.OK Then
            m_SaveFile = SaveFileDialog1.FileName
            MessageBox.Show("Otwórz plik: " & m_SaveFile, "Ok", MessageBoxButtons.OK, MessageBoxIcon.Information)
        End If
    End Sub
End Class
