﻿Imports System.Runtime.CompilerServices
Imports System.Text.RegularExpressions

Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        Dim txt As String = ""

        ' String.MatchesRegEx.
        txt &= "String.MatchesRegEx" & vbCrLf
        Dim str1 As String = "222-333-4444"
        If str1.MatchesRegEx("^([2-9]{3}-)?[2-9]{3}-\d{4}$") Then
            txt &= "    " & str1 & " pasuje" & vbCrLf
        Else
            txt &= "    " & str1 & " nie pasuje" & vbCrLf
        End If

        Dim str2 As String = "122-333-4444"
        If str2.MatchesRegEx("^([2-9]{3}-)?[2-9]{3}-\d{4}$") Then
            txt &= "    " & str2 & " pasuje" & vbCrLf
        Else
            txt &= "    " & str2 & " nie pasuje" & vbCrLf
        End If
        txt &= vbCrLf

        txt &= "List(Of Integer).Randomize()" & vbCrLf
        Dim arr As New List(Of Integer)
        For i As Integer = 1 To 20
            arr.Add(i)
        Next i
        arr.Randomize()
        txt &= "    "
        For i As Integer = 0 To arr.Count - 1
            txt &= arr(i) & " "
        Next i
        txt &= vbCrLf & vbCrLf

        Dim chosen() As Integer = ChooseN(arr, 5)
        txt &= "ChooseN(arr, 5)" & vbCrLf & "    "
        For i As Integer = 0 To chosen.Count - 1
            txt &= chosen(i) & " "
        Next i
        txt &= vbCrLf & vbCrLf

        ' To samo przy użyciu delegatu funkcji.
        Dim pick As Func(Of List(Of Integer), Integer, Integer()) = AddressOf ChooseN(Of Integer)
        Dim picked() As Integer = pick(arr, 5)
        txt &= "pick(arr, 5)" & vbCrLf & "    "
        For i As Integer = 0 To picked.Count - 1
            txt &= picked(i) & " "
        Next i
        txt &= vbCrLf & vbCrLf

        ' Tworzy drzewo.
        Dim root As New TreeNode(Of String)("Grandparent")
        root.Children.Add(New TreeNode(Of String)("Child 0"))
        root.Children.Add(New TreeNode(Of String)("Child 1"))
        root.Children(0).Children.Add(New TreeNode(Of String)("Grandchild 0-1"))
        root.Children(0).Children.Add(New TreeNode(Of String)("Grandchild 0-2"))
        root.Children(0).Children.Add(New TreeNode(Of String)("Grandchild 0-3"))
        root.Children(1).Children.Add(New TreeNode(Of String)("Grandchild 1-1"))
        root.Children(1).Children.Add(New TreeNode(Of String)("Grandchild 1-2"))
        root.Children(1).Children(1).Children.Add(New TreeNode(Of String)("Great grandchild 1-1-0"))
        txt &= root.ToString()

        ' To jest dozwolone.
        Dim max_index1 = Function(lst As List(Of Integer)) lst.Count - 1

        ' To jest niedozwolone.
        ' Dim max_index2 = Function(Of T)(lst As List(Of T)) lst.Count - 1

        txtResults.Text = txt
        txtResults.Select(0, 0)
    End Sub

    ' Pobiera num_items losowych wartości z List(Of T).
    Function ChooseN(Of T)(ByVal lst As List(Of T), ByVal num_items As Integer) As T()
        lst.Randomize()
        Dim results(num_items - 1) As T
        For i As Integer = 0 To num_items - 1
            results(i) = lst(i)
        Next i
        Return results
    End Function
End Class

Module ExtensionStuff
    ' Metoda rozszerzająca dodająca do klasy String.
    ' Zwraca True, jeśli łańcuch pasuje do wyrażenia regularnego.
    <Extension()> _
    Public Function MatchesRegEx(ByVal str As String, ByVal expression As String) As Boolean
        Dim reg As New Regex(expression)
        Return reg.IsMatch(str)
    End Function

    <Extension()> _
    Public Sub Randomize(Of T)(ByVal lst As List(Of T))
        Dim rand As New Random()
        Dim num_items As Integer = lst.Count
        For i As Integer = 0 To num_items - 2
            ' Pobiera losowy element.
            Dim j As Integer = rand.Next(i, num_items)

            ' Zamienia elementy.
            Switcher.Switch(lst(i), lst(j))
        Next i
    End Sub
End Module

' Klasa ze współdzieloną ogólną metodą.
Public Class Switcher
    Public Shared Sub Switch(Of T)(ByRef thing1 As T, ByRef thing2 As T)
        Dim temp As T = thing1
        thing1 = thing2
        thing2 = temp
    End Sub
End Class

' Klasa ogólna. Typ T jest daną związaną z węzłem.
Public Class TreeNode(Of T)
    Public Data As T
    Public Children As New List(Of TreeNode(Of T))

    Public Sub New(ByVal new_Data As T)
        Data = new_Data
    End Sub

    ' Zwraca łańcuch pokazujący strukturę drzewa.
    Public Overloads Function ToString(Optional ByVal indent As Integer = 0) As String
        Dim txt As String = Space(indent) & Data.ToString & vbCrLf

        For Each child As TreeNode(Of T) In Children
            txt &= child.ToString(indent + 4)
        Next child

        Return txt
    End Function
End Class