﻿Public Class Form1
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ShowAllSettings()
    End Sub

    ' Sprawdza ustawienie.
    Private Sub btnGet_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnGet.Click
        txtSettingValue.Text = GetSetting( _
            Application.ProductName, _
            "Config", _
            txtSettingName.Text, _
            "<Nothing>")
        ShowAllSettings()
    End Sub

    ' Zapisuje ustawienie.
    Private Sub btnSet_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSet.Click
        SaveSetting( _
            Application.ProductName, _
            "Config", _
            txtSettingName.Text, _
            txtSettingValue.Text)
        ShowAllSettings()
    End Sub

    ' Wyświetla wszystkie ustawienia Config rejestru.
    Private Sub ShowAllSettings()
        lvSettings.Items.Clear()

        Dim settings(,) As String = GetAllSettings( _
            Application.ProductName, "Config")
        If settings IsNot Nothing Then
            For i As Integer = 0 To settings.GetUpperBound(0)
                Dim new_item As ListViewItem = lvSettings.Items.Add(settings(i, 0))
                new_item.SubItems.Add(settings(i, 1))
            Next i
        End If
        lvSettings.Columns(0).Width = -2
        lvSettings.Columns(1).Width = -2
    End Sub

    ' Usuwa ustawienie.
    Private Sub btnDelete_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDelete.Click
        DeleteSetting(Application.ProductName, _
            "Config", _
            txtSettingName.Text)
        ShowAllSettings()
    End Sub

    ' Wyświetla nazwę wybranego ustawienia w polu tekstowym.
    Private Sub lvSettings_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lvSettings.SelectedIndexChanged
        txtSettingName.Clear()
        txtSettingValue.Clear()

        If lvSettings.SelectedItems.Count > 0 Then
            txtSettingName.Text = lvSettings.SelectedItems(0).Text
        End If
    End Sub
End Class
