﻿Imports System.Drawing.Printing

Public Class Form1
    ' PrintDocument.
    Private WithEvents m_PrintDocument As New PrintDocument

    ' Informacje o akapitach do wydrukowania.
    Private Structure ParagraphInfo
        Public FontSize As Integer
        Public Text As String
        Public Sub New(ByVal font_size As Integer, ByVal txt As String)
            FontSize = font_size
            Text = txt
        End Sub
    End Structure

    ' Akapity.
    Private m_Paragraphs As Collection
    Private m_ParagraphsToPrint As Collection
    Private m_PagesPrinted As Integer

    ' Ładuje informacje akapitów.
    Private Sub Form1_Load() Handles MyBase.Load
        ' Przywiązuje PrintDocument do 
        ' PrintDialog i PrintPreviewDialog.
        dlgPrint.Document = m_PrintDocument
        dlgPrintPreview.Document = m_PrintDocument

        ' Tworzy tekst do wydrukowania.
        m_Paragraphs = New Collection
        m_Paragraphs.Add(New ParagraphInfo(45, "34"))
        m_Paragraphs.Add(New ParagraphInfo(36, "Printing"))
        m_Paragraphs.Add(New ParagraphInfo(16, "This example uses ""Lorem Ipsum"" text. For more information, see http://www.lipsum.com/."))
        m_Paragraphs.Add(New ParagraphInfo(16, "Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Nunc consectetuer massa tristique urna. Suspendisse semper erat at tellus. Morbi quis urna. Donec ante justo, lobortis eget, dapibus sit amet, laoreet non, lorem. Morbi et diam. Maecenas tempor posuere pede. Suspendisse potenti. Aenean fringilla lacinia ante. Nullam fermentum nulla non mi. Cras quis elit. Morbi libero eros, porttitor nec, viverra eu, mollis sit amet, nunc."))
        m_Paragraphs.Add(New ParagraphInfo(16, "Suspendisse potenti. Vivamus quam mauris, tincidunt ac, condimentum et, vestibulum eu, nibh. Morbi tellus. Duis nisl purus, pulvinar eget, tincidunt non, varius at, urna. Proin eu velit. Sed faucibus, ligula sit amet elementum ultricies, magna lorem semper dolor, id sollicitudin nisl pede sed felis."))
        m_Paragraphs.Add(New ParagraphInfo(27, "How Not To Print"))
        m_Paragraphs.Add(New ParagraphInfo(16, "Nunc non neque at dolor eleifend fermentum. Morbi ac risus sed neque elementum congue. Maecenas et nunc in metus tempor fermentum. Ut quis felis ut nisi laoreet fermentum. Quisque et augue ut enim aliquam lobortis. Nunc lacinia, nulla id euismod laoreet, pede massa mollis risus, commodo mattis libero est a odio. Ut nisi lacus, eleifend at, commodo eget, ullamcorper non, est."))
        m_Paragraphs.Add(New ParagraphInfo(16, "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Cras a eros. Integer vel magna sit amet nibh convallis tristique. Ut sed orci. Vivamus eget dolor. Vestibulum feugiat. Nulla facilisi. Proin eu massa vel felis iaculis vehicula. Duis in ante. Quisque aliquet, nisi non pretium accumsan, sapien sem dapibus libero, eu iaculis dui metus sit amet massa. Vestibulum ultrices bibendum purus. Etiam libero lectus, ullamcorper at, viverra eu, pretium vitae, arcu."))
        m_Paragraphs.Add(New ParagraphInfo(27, "Basic Printing"))
        m_Paragraphs.Add(New ParagraphInfo(16, "Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Nulla ut lorem. Mauris vitae elit. Sed scelerisque arcu ut ipsum. Cras vulputate mollis lectus. Integer aliquam. Quisque vulputate, massa quis eleifend eleifend, massa libero vulputate quam, nec mollis dui massa sit amet tellus. Fusce pharetra, tellus ut interdum tempus, sem risus mattis dolor, vel posuere urna eros porta orci. Curabitur eu urna. Phasellus urna."))
        m_Paragraphs.Add(New ParagraphInfo(16, "Sed laoreet, elit sodales mollis consectetuer, enim tortor faucibus ligula, ac hendrerit est ante sodales dui. Curabitur bibendum facilisis eros. Praesent sapien. Proin malesuada lacus a augue dictum tincidunt. Maecenas elementum ultricies neque. In ullamcorper. Phasellus fringilla varius quam. In nisl."))
        m_Paragraphs.Add(New ParagraphInfo(16, "Donec vulputate vestibulum enim. Quisque purus pede, pharetra sed, volutpat ac, sollicitudin eu, erat. Maecenas suscipit odio id nulla. Maecenas tincidunt nisi at erat. Donec et tellus luctus nisi ultrices sollicitudin. Cras nec turpis. Proin sit amet elit quis sem tincidunt pulvinar. Aenean tempus. Praesent vitae mauris. Integer sit amet eros."))
        m_Paragraphs.Add(New ParagraphInfo(16, "Curabitur hendrerit. Aliquam erat volutpat. Cras pede. Integer id magna mattis ligula feugiat blandit. Nullam eget orci. Morbi at velit pretium nisi rutrum vulputate. Nulla suscipit nisl euismod diam."))
        m_Paragraphs.Add(New ParagraphInfo(27, "Printing Text"))
        m_Paragraphs.Add(New ParagraphInfo(16, "Ut risus enim, blandit eu, gravida quis, euismod non, nisl. Sed scelerisque. Nunc mauris. Nullam non neque id orci rhoncus eleifend. Curabitur laoreet, nunc vitae sagittis feugiat, elit nisl gravida elit, at tincidunt velit tortor vel quam. Mauris arcu mauris, cursus sed, tempor vel, tincidunt in, quam. Mauris pellentesque. Ut tristique lacus ultrices eros."))
        m_Paragraphs.Add(New ParagraphInfo(16, "Vestibulum consequat elit vel massa. Fusce velit. Integer sit amet justo. Vivamus nonummy pharetra nisl. Etiam mollis. Vivamus semper volutpat massa. Morbi enim nulla, lobortis vel, posuere at, porta sit amet, orci."))
        m_Paragraphs.Add(New ParagraphInfo(16, "Fusce cursus, felis non pharetra condimentum, magna nibh placerat dui, sed posuere metus sem vel lacus. Cras adipiscing eros. Sed imperdiet justo id ante."))
        m_Paragraphs.Add(New ParagraphInfo(27, "Centering Printouts"))
        m_Paragraphs.Add(New ParagraphInfo(16, "Morbi pretium odio sit amet orci. Mauris molestie, lacus in dictum convallis, nisi odio luctus tortor, non malesuada metus augue ac purus."))
        m_Paragraphs.Add(New ParagraphInfo(16, "Fusce nonummy lorem. Suspendisse interdum, justo a porta consectetuer, elit purus varius purus, ac adipiscing dolor turpis accumsan dolor. Pellentesque molestie justo ut pede."))
        m_Paragraphs.Add(New ParagraphInfo(16, "Sed commodo neque nec nisi. Vestibulum eleifend, mauris ac congue feugiat, tortor eros molestie eros, ut varius odio mauris nec ligula. Phasellus convallis velit at ante. Integer quis nisi. Pellentesque quis tortor. Praesent ut odio ut quam feugiat aliquet. Nam sit amet urna. Nulla ultricies."))
        m_Paragraphs.Add(New ParagraphInfo(27, "Fitting Pictures to the Page"))
        m_Paragraphs.Add(New ParagraphInfo(16, "Proin sed massa. Cras elementum est gravida diam. Nulla vel libero quis elit scelerisque interdum. Quisque malesuada, tortor vitae ultricies volutpat, ipsum odio lacinia lorem, eu semper arcu purus eget arcu. Nullam quis magna a massa tempus vestibulum. Duis ultricies. Duis nec metus id sapien porta placerat. Nam justo metus, cursus ac, aliquet at, porta id, neque. Donec consequat est eget lacus. Curabitur massa tortor, vestibulum vel, venenatis at, rutrum ut, arcu."))
        m_Paragraphs.Add(New ParagraphInfo(16, "Sed velit. Fusce est. Donec dui justo, volutpat ut, hendrerit vestibulum, ullamcorper vitae, lorem. Sed facilisis tincidunt lorem. Morbi nec ipsum. Ut ornare tempor sapien. Sed magna libero, scelerisque consequat, ornare vitae, fringilla et, urna. Nunc adipiscing. Proin sed augue. Sed dignissim. Nam sagittis sem nec risus. Vestibulum tellus. Cras mattis ultrices lacus. Proin euismod velit vel orci. Maecenas rhoncus pede vel pede. Mauris nibh ligula, imperdiet in, tristique a, sodales ac, orci."))
        m_Paragraphs.Add(New ParagraphInfo(16, "Pellentesque porttitor quam quis libero. Aliquam urna neque, adipiscing in, ultricies non, bibendum sed, odio. Suspendisse enim. Cras tortor. Curabitur venenatis turpis."))
    End Sub

    ' Wyświetla okno dialogowe podglądu wydruku.
    Private Sub btnPrintPreview_Click() Handles btnPrintPreview.Click
        dlgPrintPreview.WindowState = FormWindowState.Maximized
        dlgPrintPreview.ShowDialog()
    End Sub

    ' Wyświetla okno dialogowe drukowania.
    Private Sub btnPrintDialog_Click() Handles btnPrintDialog.Click
        dlgPrint.ShowDialog()
    End Sub

    ' Drukuje natychmiast.
    Private Sub btnPrintNow_Click() Handles btnPrintNow.Click
        m_PrintDocument.Print()
    End Sub

    ' Przygotowuje się do drukowania stron.
    Private Sub m_PrintDocument_BeginPrint() Handles m_PrintDocument.BeginPrint
        ' We have not yet printed any pages.
        m_PagesPrinted = 0

        ' Tworzy kopię tekstu do wydrukowania.
        m_ParagraphsToPrint = New Collection
        For Each para_info As ParagraphInfo In m_Paragraphs
            m_ParagraphsToPrint.Add(New ParagraphInfo(para_info.FontSize, para_info.Text))
        Next para_info
    End Sub

    ' Ustawia marginesy.
    Private Sub m_PrintDocument_QueryPageSettings(ByVal sender As Object, ByVal e As System.Drawing.Printing.QueryPageSettingsEventArgs) Handles m_PrintDocument.QueryPageSettings
        ' Obszar na bindowanie szerokości jednego cala (1 cal to 100 jednostek drukarki).
        Const gutter As Integer = 100

        ' Sprawdza czy kolejna strona będzie pierwszą, parzystą, czy nieparzystą.
        If m_PagesPrinted = 0 Then
            ' Następna strona jest pierwsza.
            ' Zwiększa lewy margines.
            e.PageSettings.Margins.Left += gutter
        ElseIf (m_PagesPrinted Mod 2) = 0 Then
            ' Następna strona jest nieparzysta.
            ' Przesuwa marginesy na prawo.
            e.PageSettings.Margins.Left += gutter
            e.PageSettings.Margins.Right -= gutter
        Else
            ' Następna strona jest parzysta.
            ' Przesuwa marginesy w lewo.
            e.PageSettings.Margins.Left -= gutter
            e.PageSettings.Margins.Right += gutter
        End If
    End Sub

    ' Drukuje następną stronę.
    Private Sub m_PrintDocument_PrintPage(ByVal sender As Object, ByVal e As System.Drawing.Printing.PrintPageEventArgs) Handles m_PrintDocument.PrintPage
        ' Zwiększa numer strony.
        m_PagesPrinted += 1

        ' Rysuje marginesy.
        'e.Graphics.DrawRectangle(Pens.Red, e.MarginBounds)

        ' Drukuje numer strony wyrównany do prawej.
        ' w górnym rogu po przeciwnej stronie obszaru na bindowanie.
        ' i poza marginesem.
        Dim x As Integer
        Using string_format As New StringFormat
            ' Sprawdza czy strona jest parzysta, czy nieparzysta.
            If (m_PagesPrinted Mod 2) = 0 Then
                ' Strona jest parzysta.
                ' Obszar na bindowanie jest po prawej a
                ' numer strony po lewej.
                x = (e.MarginBounds.Left + e.PageBounds.Left) \ 2
                string_format.Alignment = StringAlignment.Near
            Else
                ' Strona jest nieparzysta.
                ' Obszar na bindowanie jest po lewej a
                ' numer strony po prawej.
                x = (e.MarginBounds.Right + e.PageBounds.Right) \ 2
                string_format.Alignment = StringAlignment.Far
            End If

            ' Drukuje numer strony.
            Using the_font As New Font("Times New Roman", 20, FontStyle.Regular, GraphicsUnit.Point)
                e.Graphics.DrawString(m_PagesPrinted.ToString, _
                    the_font, Brushes.Black, x, _
                    (e.MarginBounds.Top + e.PageBounds.Top) \ 2, _
                    string_format)
            End Using ' the_font

            ' Rysuje resztę tekstu wyrównanego do lewej,
            ' zawija według słów i nie rysuje kawałków wierszy.
            string_format.Alignment = StringAlignment.Near
            string_format.FormatFlags = StringFormatFlags.LineLimit
            string_format.Trimming = StringTrimming.Word

            ' Rysuje tekst.
            Dim paragraph_info As ParagraphInfo
            Dim ymin As Integer = e.MarginBounds.Top
            Dim layout_rect As RectangleF
            Dim text_size As SizeF
            Dim characters_fitted As Integer
            Dim lines_filled As Integer
            Do While m_ParagraphsToPrint.Count > 0
                ' Drukuje następny akapit.
                paragraph_info = DirectCast(m_ParagraphsToPrint(1), ParagraphInfo)
                m_ParagraphsToPrint.Remove(1)

                ' Pobiera obszar dostępny dla tego akapitu.
                layout_rect = New RectangleF( _
                    e.MarginBounds.Left, ymin, _
                    e.MarginBounds.Width, _
                    e.MarginBounds.Bottom - ymin)
                If layout_rect.Height < 1 Then layout_rect.Height = 1

                ' Sprawdza rozmiar tekstu i
                ' ile znaków będzie pasować.
                ' Sprawdza font.
                Using the_font As New Font("Times New Roman", paragraph_info.FontSize, FontStyle.Regular, GraphicsUnit.Point)
                    text_size = e.Graphics.MeasureString( _
                        paragraph_info.Text, the_font, _
                        New SizeF(layout_rect.Width, layout_rect.Height), _
                        string_format, characters_fitted, lines_filled)

                    ' Sprawdza czy jakieś znaki będą pasować.
                    If characters_fitted > 0 Then
                        ' Rysuje tekst.
                        e.Graphics.DrawString(paragraph_info.Text, _
                            the_font, Brushes.Black, _
                            layout_rect, string_format)

                        ' Debugowanie: Rysuje prostokąt wokół tekstu.
                        'e.Graphics.DrawRectangle(Pens.Green, _
                        '    layout_rect.Left, _
                        '    layout_rect.Top, _
                        '    text_size.Width, _
                        '    text_size.Height)

                        ' Zwiększa przestrzeń drukowania.
                        ' Dodanie odstępu między akapitami.
                        ymin += CInt(text_size.Height + _
                            e.Graphics.MeasureString("M", the_font).Height / 2)
                    End If
                End Using ' the_font

                ' Sprawdzenie, czy jakaś część akapitu nie zmieściła się na stronie.
                If characters_fitted < Len(paragraph_info.Text) Then
                    ' Jakaś część akapitu nie zmieściła się.
                    ' Przygotowanie do wydrukowania jej na następnej stronie.
                    paragraph_info.Text = paragraph_info.Text. _
                        Substring(characters_fitted)
                    m_ParagraphsToPrint.Add(paragraph_info, Before:=1)

                    ' To wszystko, co zmieści się na tej stronie.
                    Exit Do
                End If
            Loop
        End Using ' string_format 

        ' Jeśli jest więcej akapitów, jest więcej stron.
        e.HasMorePages = (m_ParagraphsToPrint.Count > 0)
    End Sub

    ' Czyszczenie.
    Private Sub m_PrintDocument_EndPrint() Handles m_PrintDocument.EndPrint
        m_ParagraphsToPrint = Nothing
    End Sub
End Class
