﻿Imports System.Drawing.Imaging

Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        ' Tworzy mapę bitową.
        Const WID As Integer = 200
        Dim bm As New Bitmap(WID, WID)

        ' Znajduje plik WMF i usuwa go, jeśli istnieje.
        Dim path_name As String = Application.StartupPath
        If path_name.EndsWith("\bin") Then path_name = path_name.Substring(0, path_name.Length - 4)
        Dim file_name As String = path_name & "\test.wmf"
        If Len(Dir$(file_name)) > 0 Then Kill(file_name)

        ' Tworzy obiekt Graphics, dzięki czemu można użyć jego hDC jako referencji.
        Using me_gr As Graphics = Me.CreateGraphics
            Dim me_hdc As IntPtr = me_gr.GetHdc

            ' Tworzy Metafile przy użyciu referencji hDC.
            Dim bounds As New RectangleF(0, 0, WID, WID)
            Using mf As New Metafile(file_name, me_hdc, _
                bounds, MetafileFrameUnit.Pixel)
                me_gr.ReleaseHdc(me_hdc)

                ' Tworzy obiekt Graphics i rysuje.
                Using gr As Graphics = Graphics.FromImage(mf)
                    gr.PageUnit = GraphicsUnit.Pixel
                    gr.Clear(Color.LightGray)
                    Using thick_pen As New Pen(Color.Red, 5)
                        gr.DrawEllipse(thick_pen, bounds)
                        thick_pen.Color = Color.Green
                        gr.DrawLine(thick_pen, 0, 0, WID, WID)
                        thick_pen.Color = Color.Blue
                        gr.DrawLine(thick_pen, WID, 0, 0, WID)
                    End Using
                End Using ' gr
            End Using ' mf

            ' Ponownie ładuje metaplik i kopiuje go do mapy bitowej.
            Using mf As New Metafile(file_name)
                Using gr As Graphics = Graphics.FromImage(bm)
                    Dim dest_bounds As New RectangleF(0, 0, WID, WID)
                    Dim source_bounds As New RectangleF(0, 0, WID + 1, WID + 1)
                    gr.DrawImage(mf, bounds, source_bounds, GraphicsUnit.Pixel)
                    picOrig.SizeMode = PictureBoxSizeMode.AutoSize
                    picOrig.Image = bm
                End Using ' gr
            End Using ' mf

            ' Ponownie wyświetla wynik zmniejszony o 50%.
            Using mf As New Metafile(file_name)
                picSmall.SetBounds( _
                    picOrig.Right + 10, picOrig.Top, _
                    picOrig.Width \ 2, picOrig.Height \ 2)
                bm = New Bitmap( _
                    picSmall.ClientSize.Width, _
                    picSmall.ClientSize.Height)
                Using gr As Graphics = Graphics.FromImage(bm)
                    Dim source_bounds As New RectangleF(0, 0, WID + 1, WID + 1)
                    gr.ScaleTransform(0.5, 0.5)
                    gr.DrawImage(mf, bounds, source_bounds, GraphicsUnit.Pixel)
                    picSmall.Image = bm
                    gr.Dispose()
                End Using ' gr
            End Using ' mf
        End Using ' me_gr
    End Sub
End Class
