﻿Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        Me.SetStyle(ControlStyles.AllPaintingInWmPaint Or ControlStyles.ResizeRedraw, True)
        Me.UpdateStyles()
    End Sub

    Private Sub Form1_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles MyBase.Paint
        e.Graphics.Clear(Me.BackColor)

        ' Wyświetla przykłady trybów WrapMode.
        Dim x As Integer = 0
        Dim y As Integer = 0
        DrawSample(e.Graphics, x, y, Drawing2D.WrapMode.Clamp)
        DrawSample(e.Graphics, x, y, Drawing2D.WrapMode.Tile)
        DrawSample(e.Graphics, x, y, Drawing2D.WrapMode.TileFlipX)
        DrawSample(e.Graphics, x, y, Drawing2D.WrapMode.TileFlipY)
        DrawSample(e.Graphics, x, y, Drawing2D.WrapMode.TileFlipXY)
    End Sub

    Private Sub DrawSample(ByVal gr As Graphics, ByRef x As Integer, ByRef y As Integer, ByVal wrap_mode As Drawing2D.WrapMode)
        Using texture_brush As New TextureBrush(My.Resources.face)
            texture_brush.WrapMode = wrap_mode
            gr.FillRectangle(texture_brush, x, y, 100, 100)
            gr.DrawRectangle(Pens.Black, x, y, 100, 100)
            gr.DrawString(texture_brush.WrapMode.ToString, Me.Font, _
                Brushes.Black, x, y + 100)
        End Using

        x += 120
        If x + 100 > Me.ClientSize.Width Then
            x = 0
            y += 160
        End If
    End Sub
End Class
