﻿Imports System.Drawing.Drawing2D

Public Class Form1
    Private Sub Form1_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles MyBase.Paint
        ' Skalowanie o współczynnik 30.
        e.Graphics.ScaleTransform(30, 30, MatrixOrder.Append)
        DrawArrow(e.Graphics, HatchStyle.Horizontal)

        ' Translacja o 150 w poziomie i 60 w pionie.
        e.Graphics.TranslateTransform(150, 60, MatrixOrder.Append)
        DrawArrow(e.Graphics, HatchStyle.Vertical)

        ' Rotacja o 30 stopni.
        e.Graphics.RotateTransform(30, MatrixOrder.Append)
        DrawArrow(e.Graphics, HatchStyle.Cross)
    End Sub

    ' Rysuje obrys strzałki.
    Private Sub DrawArrow(ByVal gr As Graphics, ByVal hatch_style As HatchStyle)
        Dim pts() As Point = { _
            New Point(0, 1), _
            New Point(2, 1), _
            New Point(2, 0), _
            New Point(4, 2), _
            New Point(2, 4), _
            New Point(2, 3), _
            New Point(0, 3) _
        }
        Using hatch_brush As New HatchBrush(hatch_style, Color.Black, Color.White)
            gr.FillPolygon(hatch_brush, pts)
        End Using

        Using black_pen As New Pen(Color.Black, 0)
            gr.DrawPolygon(black_pen, pts)
        End Using
    End Sub
End Class
