﻿Imports PersonTree = GenericTreeImportsAlias.Tree(Of GenericTreeImportsAlias.Person)
Imports PersonNode = GenericTreeImportsAlias.TreeNode(Of GenericTreeImportsAlias.Person)

Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        ' Tworzy drzewo i jego korzeń.
        Dim family_tree As New PersonTree
        Dim root As PersonNode = _
            family_tree.MakeRoot(New Person("Me"))

        ' Tworzy generację rodziców.
        Dim child1 As PersonNode = _
            root.AddChild(New Person("Child 1"))
        Dim child2 As PersonNode = _
            root.AddChild(New Person("Child 2"))

        ' Tworzy generacje dziadków.
        child1.AddChild(New Person("Grandchild 1"))
        child1.AddChild(New Person("Grandchild 2"))
        child1.AddChild(New Person("Grandchild 3"))
        child2.AddChild(New Person("Grandchild 4"))
        child2.AddChild(New Person("Grandchild 5"))

        ' Wyświetla wynik.
        txtTree.Text = family_tree.ToString()
        txtTree.Select(0, 0)
    End Sub
End Class

Public Class Person
    Public Name As String
    Public Sub New(ByVal new_name As String)
        Name = new_name
    End Sub
    Public Overrides Function ToString() As String
        Return Name
    End Function
End Class
