﻿Imports System.ComponentModel

' Lista najwyżej MaxItems elementów.
' Najnowszy element jest na pozycji 0.
Public Class MostRecentList(Of ItemType)
    ' Initialize MaxItems for the new list.
    Public Sub New(ByVal max_items As Integer)
        MaxItems = max_items
    End Sub

    ' Własność Item.
    Private m_Items As New List(Of ItemType)
    <Description("Elementy."), _
     Category("Data")> _
    Public Property Item(ByVal index As Integer) As ItemType
        Get
            Return m_Items(index)
        End Get
        Set(ByVal value As ItemType)
            m_Items(index) = value
        End Set
    End Property

    ' Własność MaxItems.
    Private m_MaxItems As Integer = 4
    <Description("Maksymalna liczba elementów na liście."), _
     Category("Data")> _
    Public Property MaxItems() As Integer
        Get
            Return m_MaxItems
        End Get
        Set(ByVal value As Integer)
            m_MaxItems = value

            ' Odpowiednia zmiana rozmiaru.
            Do While m_Items.Count > m_MaxItems
                m_Items.RemoveAt(m_Items.Count - 1)
            Loop
        End Set
    End Property

    ' Aktualna liczba elementów.
    <Description("Aktualna liczba elementów."), _
     Category("Data")> _
    Public ReadOnly Property Count() As Integer
        Get
            Return m_Items.Count
        End Get
    End Property

    ' Dodaje element na początek listy.
    Public Sub Add(ByVal value As ItemType)
        ' Usuwa element, jeśli już istnieje.
        If m_Items.Contains(value) Then m_Items.Remove(value)

        ' Dodaje element na początku listy.
        m_Items.Insert(0, value)

        ' Upewnienie się, że nie ma więcej niż MaxItems elementów.
        If m_Items.Count > m_MaxItems Then m_Items.RemoveAt(m_Items.Count - 1)
    End Sub

    ' Usuwa element.
    Public Sub Remove(ByVal value As ItemType)
        m_Items.Remove(value)
    End Sub

    ' Usuwa element znajdujący się w określonym miejscu.
    Public Sub RemoveAt(ByVal index As Integer)
        m_Items.RemoveAt(index)
    End Sub
End Class