﻿Imports System.Collections.Generic

Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        Dim emp_list As New EmployeeList
        emp_list.Add(New Employee("Groucho", "Marx"))
        emp_list.Add("Zero", "Mostel")
        emp_list.Add("Steve", "Martin")
        emp_list.Add("Chevy", "Chase")

        Dim txt As String = ""
        For Each emp As Employee In emp_list
            txt &= emp.ToString & vbCrLf
        Next emp
        txtResults.Text = txt
        txtResults.Select(0, 0)
    End Sub
End Class

Public Class Employee
    Private m_FirstName As String
    Private m_LastName As String
    Public Sub New(ByVal first_name As String, ByVal last_name As String)
        m_FirstName = first_name
        m_LastName = last_name
    End Sub
    Public Overrides Function ToString() As String
        Return m_FirstName & " " & m_LastName
    End Function
End Class

Public Class EmployeeList
    Inherits List(Of Employee)

    Public Overloads Sub Add(ByVal first_name As String, ByVal last_name As String)
        Dim emp As New Employee(first_name, last_name)
        MyBase.Add(emp)
    End Sub
End Class
