﻿Public Class Form1

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Dim txt As String = ""

        ' Znajduje indeksy wyznaczonych wartości.
        txt &= IndexesOf()

        ' Odwraca tablicę.
        txt &= Reverse()

        ' Sortuje trochę ludzi.
        txt &= SortPeople()

        ' Sortuje trochę kierowników.
        txt &= SortManagers()

        ' Szuka.
        txt &= BinarySearch()

        txtResults.Text = txt
        txtResults.Select(0, 0)
    End Sub

    Private Function IndexesOf() As String
        Dim txt As String = ""

        Dim values(10) As Integer
        For i As Integer = 0 To 5
            values(i) = i
        Next i
        For i As Integer = 6 To 10
            values(i) = 10 - i
        Next i

        'Dim values As Array = _
        '    Array.CreateInstance(GetType(Integer), 11)
        'For i As Integer = 0 To 10
        '    values.SetValue(i, i)
        'Next i

        txt &= "Indeksy: "
        For i As Integer = 0 To 10
            txt &= values(i) & " "
        Next i
        txt &= vbCrLf
        txt &= "    Indeks 4 to " & Array.IndexOf(values, 4).ToString & vbCrLf
        txt &= "    Index 6 to " & Array.IndexOf(values, 6).ToString & vbCrLf
        txt &= "    Ostatni indeks 3 to " & Array.LastIndexOf(values, 3).ToString & vbCrLf
        Return txt & vbCrLf
    End Function

    Private Function Reverse() As String
        Dim txt As String = ""

        Dim values(9) As Integer
        For i As Integer = 0 To 9
            values(i) = i
        Next i

        txt &= "Tablica:    "
        For i As Integer = 0 To 9
            txt &= values(i) & " "
        Next i
        txt &= vbCrLf

        Array.Reverse(values)

        txt &= "Odwrócona: "
        For i As Integer = 0 To 9
            txt &= values(i) & " "
        Next i
        txt &= vbCrLf

        Return txt & vbCrLf
    End Function

    Private Function SortPeople() As String
        ' Make the array of Person objects.
        Dim people(4) As Person
        people(0) = New Person("Rod", "Stephens")
        people(1) = New Person("Sergio", "Aragones")
        people(2) = New Person("Terry", "Pratchett")
        people(3) = New Person("Homer", "Simpson")
        people(4) = New Person("Eoin", "Colfer")

        Dim txt As String = "Ludzie:" & vbCrLf
        For i As Integer = 0 To people.Length - 1
            txt &= "    " & people(i).ToString() & vbCrLf
        Next i

        ' Sortowanie.
        Array.Sort(people)

        txt &= "Po posortowaniu:" & vbCrLf
        For i As Integer = 0 To people.Length - 1
            txt &= "    " & people(i).ToString() & vbCrLf
        Next i

        Return txt & vbCrLf
    End Function

    Private Function SortManagers() As String
        ' Make the array of Manager objects.
        Dim managers(4) As Manager
        managers(0) = New Manager("Rod", "Stephens")
        managers(1) = New Manager("Sergio", "Aragones")
        managers(2) = New Manager("Terry", "Pratchett")
        managers(3) = New Manager("Homer", "Simpson")
        managers(4) = New Manager("Eoin", "Colfer")

        Dim txt As String = "Kierownicy:" & vbCrLf
        For i As Integer = 0 To managers.Length - 1
            txt &= "    " & managers(i).ToString() & vbCrLf
        Next i

        ' Tworzenie komparatora.
        Dim manager_comparer As New ManagerComparer

        ' Sortowanie.
        Array.Sort(managers, manager_comparer)

        txt &= "Po posortowaniu:" & vbCrLf
        For i As Integer = 0 To managers.Length - 1
            txt &= "    " & managers(i).ToString() & vbCrLf
        Next i

        Return txt & vbCrLf
    End Function

    Private Function BinarySearch() As String
        ' Tworzenie tablicy obiektów Person.
        Dim people(4) As Person
        people(0) = New Person("Rod", "Stephens")
        people(1) = New Person("Sergio", "Aragones")
        people(2) = New Person("Terry", "Pratchett")
        people(3) = New Person("Homer", "Simpson")
        people(4) = New Person("Eoin", "Colfer")

        ' Sortowanie tablicy.
        Array.Sort(people)

        ' Szuka Roda Stephensa.
        Dim target_person As New Person("Rod", "Stephens")
        Dim target_index As Integer = Array.BinarySearch(people, target_person)
        target_person = people(target_index)

        Return "Algorytm BinarySearch znalazł osobę " & _
            target_person.ToString & " pod indeksem " & _
            target_index & vbCrLf & vbCrLf
    End Function
End Class

Public Class Person
    Implements IComparable

    Public FirstName As String
    Public LastName As String

    Public Sub New(ByVal first_name As String, ByVal last_name As String)
        FirstName = first_name
        LastName = last_name
    End Sub

    Public Overrides Function ToString() As String
        Return LastName & ", " & FirstName
    End Function

    Public Function CompareTo(ByVal obj As Object) As Integer _
     Implements System.IComparable.CompareTo
        Dim other_Person As Person = DirectCast(obj, Person)
        Return String.Compare(Me.ToString, other_Person.ToString)
    End Function
End Class

Public Class Manager
    Public FirstName As String
    Public LastName As String

    Public Sub New(ByVal first_name As String, ByVal last_name As String)
        FirstName = first_name
        LastName = last_name
    End Sub

    Public Overrides Function ToString() As String
        Return LastName & ", " & FirstName
    End Function
End Class

Public Class ManagerComparer
    Implements IComparer

    Public Function Compare(ByVal x As Object, ByVal y As Object) As Integer _
     Implements System.Collections.IComparer.Compare
        Dim mgr1 As Manager = DirectCast(x, Manager)
        Dim mgr2 As Manager = DirectCast(y, Manager)

        Return String.Compare(mgr1.ToString, mgr2.ToString)
    End Function
End Class
