﻿' Wymaga referencji do System.Xml.
Imports System.Xml.Serialization
Imports System.IO

Public Class Form1
    ' Jeśli atrybut Serializable usuniesz za pomocą komentarza,
    ' program będzie nadal obsługiwał przeciąganie danych w
    ' obrębie jednej instancji programu, ale nie pozwoli na
    ' przeciąganie danych między różnymi instancjami.
    <Serializable()> _
    Public Class Employee
        Public FirstName As String
        Public LastName As String
        Public Sub New()
        End Sub
        Public Sub New(ByVal first_name As String, ByVal last_name As String)
            FirstName = first_name
            LastName = last_name
        End Sub
    End Class

    ' Początek przeciągania obiektu Employee.
    Private Sub lblDragSource_MouseDown() Handles lblDragSource.MouseDown
        Dim emp As New Employee(txtFirstName.Text, txtLastName.Text)
        Dim data_object As New DataObject()
        data_object.SetData("Employee", emp)

        If lblDragSource.DoDragDrop(data_object, _
            DragDropEffects.Copy Or DragDropEffects.Move) = DragDropEffects.Move _
        Then
            ' Przenoszenie zakończone powodzeniem. Czyszczenie pól TextBox.
            txtFirstName.Text = ""
            txtLastName.Text = ""
        End If
    End Sub

    ' Jeśli obiekt Employee jest dostępny, zezwala na przenoszenie
    ' lub kopiowanie, w zależności od tego, czy był wciśnięty klawisz Ctrl.
    Private Sub lblDropTarget_DragOver(ByVal sender As Object, ByVal e As System.Windows.Forms.DragEventArgs) Handles lblDropTarget.DragOver
        If e.Data.GetDataPresent("Employee") Then
            ' Wyświetla kursor Move lub Copy.
            Const KEY_CTRL As Integer = 8
            If (e.KeyState And KEY_CTRL) <> 0 Then
                e.Effect = DragDropEffects.Copy
            Else
                e.Effect = DragDropEffects.Move
            End If
        End If
    End Sub

    ' Wyświetla upuszczony obiekt Employee.
    Private Sub lblDropTarget_DragDrop(ByVal sender As Object, ByVal e As System.Windows.Forms.DragEventArgs) Handles lblDropTarget.DragDrop
        Dim emp As Employee = DirectCast(e.Data.GetData("Employee"), Employee)
        lblFirstName.Text = emp.FirstName
        lblLastName.Text = emp.LastName
    End Sub

    ' Wyświetla serializację obiektu Employee.
    Private Sub btnShowSerialization_Click() Handles btnShowSerialization.Click
        Dim emp As New Employee(txtFirstName.Text, txtLastName.Text)
        Dim string_writer As New StringWriter()
        Dim serializer As New XmlSerializer(GetType(Employee))
        serializer.Serialize(string_writer, emp)
        MessageBox.Show(string_writer.ToString, _
            "Serializacja", MessageBoxButtons.OK, _
            MessageBoxIcon.Information)
    End Sub
End Class
