﻿Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        ' Tworzenie danych.
        Dim all_customers As New List(Of Person)
        all_customers.Add(New Person() With {.FirstName = "Ben", .LastName = "Best", .CustId = 2})
        all_customers.Add(New Person() With {.FirstName = "Frank", .LastName = "Fix", .CustId = 4})
        all_customers.Add(New Person() With {.FirstName = "Ann", .LastName = "Archer", .CustId = 5})
        all_customers.Add(New Person() With {.FirstName = "Edna", .LastName = "Ever", .CustId = 3})
        all_customers.Add(New Person() With {.FirstName = "Carly", .LastName = "Cant", .CustId = 6})
        all_customers.Add(New Person() With {.FirstName = "Dan", .LastName = "Dump", .CustId = 1})

        Dim all_orders As New List(Of Order)
        all_orders.Add(New Order() With {.CustId = 1, .OrderId = 103, .OrderDate = #4/12/2008#})
        all_orders.Add(New Order() With {.CustId = 1, .OrderId = 101, .OrderDate = #4/4/2008#})
        all_orders.Add(New Order() With {.CustId = 3, .OrderId = 102, .OrderDate = #4/7/2008#})
        all_orders.Add(New Order() With {.CustId = 1, .OrderId = 104, .OrderDate = #4/15/2008#})
        all_orders.Add(New Order() With {.CustId = 2, .OrderId = 106, .OrderDate = #4/23/2008#})
        all_orders.Add(New Order() With {.CustId = 2, .OrderId = 100, .OrderDate = #4/7/2008#})
        all_orders.Add(New Order() With {.CustId = 2, .OrderId = 105, .OrderDate = #4/19/2008#})
        all_orders.Add(New Order() With {.CustId = 3, .OrderId = 107, .OrderDate = #4/9/2008#})
        all_orders.Add(New Order() With {.CustId = 3, .OrderId = 108, .OrderDate = #4/2/2008#})
        all_orders.Add(New Order() With {.CustId = 3, .OrderId = 109, .OrderDate = #4/11/2008#})
        all_orders.Add(New Order() With {.CustId = 6, .OrderId = 110, .OrderDate = #4/15/2008#})

        Dim all_order_items As New List(Of OrderItem)
        all_order_items.Add(New OrderItem() With {.OrderId = 100, .Description = "Notebook", .UnitPrice = 2.5, .Quantity = 6})
        all_order_items.Add(New OrderItem() With {.OrderId = 100, .Description = "Pen, dozen", .UnitPrice = 2.65, .Quantity = 12})
        all_order_items.Add(New OrderItem() With {.OrderId = 100, .Description = "Banana", .UnitPrice = 2.2, .Quantity = 1})
        all_order_items.Add(New OrderItem() With {.OrderId = 101, .Description = "Cookie", .UnitPrice = 1.25, .Quantity = 144})
        all_order_items.Add(New OrderItem() With {.OrderId = 101, .Description = "Notebook", .UnitPrice = 2.5, .Quantity = 6})
        all_order_items.Add(New OrderItem() With {.OrderId = 101, .Description = "Pen, dozen", .UnitPrice = 2.65, .Quantity = 12})
        all_order_items.Add(New OrderItem() With {.OrderId = 101, .Description = "Soda", .UnitPrice = 0.75, .Quantity = 4})
        all_order_items.Add(New OrderItem() With {.OrderId = 102, .Description = "Paper, ream", .UnitPrice = 3.5, .Quantity = 6})
        all_order_items.Add(New OrderItem() With {.OrderId = 102, .Description = "Pen, dozen", .UnitPrice = 2.65, .Quantity = 2})
        all_order_items.Add(New OrderItem() With {.OrderId = 102, .Description = "Notebook", .UnitPrice = 2.5, .Quantity = 6})
        all_order_items.Add(New OrderItem() With {.OrderId = 103, .Description = "Apple", .UnitPrice = 0.75, .Quantity = 6})
        all_order_items.Add(New OrderItem() With {.OrderId = 103, .Description = "Bean, Can", .UnitPrice = 1.15, .Quantity = 6})
        all_order_items.Add(New OrderItem() With {.OrderId = 103, .Description = "Cookie", .UnitPrice = 1.25, .Quantity = 3})
        all_order_items.Add(New OrderItem() With {.OrderId = 103, .Description = "Pencil, dozen", .UnitPrice = 1.35, .Quantity = 4})
        all_order_items.Add(New OrderItem() With {.OrderId = 104, .Description = "Notebook", .UnitPrice = 2.5, .Quantity = 2})
        all_order_items.Add(New OrderItem() With {.OrderId = 104, .Description = "Flamethrower", .UnitPrice = 1750, .Quantity = 1})
        all_order_items.Add(New OrderItem() With {.OrderId = 104, .Description = "Notebook", .UnitPrice = 2.5, .Quantity = 4})
        all_order_items.Add(New OrderItem() With {.OrderId = 105, .Description = "Paper, ream", .UnitPrice = 3.5, .Quantity = 10})
        all_order_items.Add(New OrderItem() With {.OrderId = 106, .Description = "Notebook", .UnitPrice = 2.5, .Quantity = 2})
        all_order_items.Add(New OrderItem() With {.OrderId = 107, .Description = "Pen, dozen", .UnitPrice = 2.65, .Quantity = 1})
        all_order_items.Add(New OrderItem() With {.OrderId = 108, .Description = "Cookie", .UnitPrice = 1.25, .Quantity = 3})
        all_order_items.Add(New OrderItem() With {.OrderId = 108, .Description = "Pencil, dozen", .UnitPrice = 1.35, .Quantity = 4})
        all_order_items.Add(New OrderItem() With {.OrderId = 109, .Description = "Notebook", .UnitPrice = 2.5, .Quantity = 6})
        all_order_items.Add(New OrderItem() With {.OrderId = 109, .Description = "Pen, dozen", .UnitPrice = 2.65, .Quantity = 12})
        all_order_items.Add(New OrderItem() With {.OrderId = 109, .Description = "Soda", .UnitPrice = 0.75, .Quantity = 4})
        all_order_items.Add(New OrderItem() With {.OrderId = 110, .Description = "Paper, ream", .UnitPrice = 3.5, .Quantity = 6})

        Dim txt As String = ""

        txt &= "CustId przed 2/15/2008" & vbCrLf
        Dim query1 = From ord In all_orders _
            Where ord.OrderDate < #4/15/2008# _
            Select ord.CustId
        For Each id As Integer In query1
            txt &= Space$(4) & id & vbCrLf
        Next id
        txt &= vbCrLf

        txt &= "Unikatowe CustId przed 2/15/2008" & vbCrLf
        Dim query2 = From ord In all_orders _
            Where ord.OrderDate < #4/15/2008# _
            Select ord.CustId _
            Distinct
        For Each id As Integer In query2
            txt &= Space$(4) & id & vbCrLf
        Next id
        txt &= vbCrLf

        txt &= "Klienci przed 2/15/2008" & vbCrLf
        Dim query3 = From cust In all_customers, ord In all_orders _
            Where cust.CustId = ord.CustId AndAlso _
                  ord.OrderDate < #4/15/2008# _
            Select cust.FirstName & " " & cust.LastName
        For Each id As String In query3
            txt &= Space$(4) & id & vbCrLf
        Next id
        txt &= vbCrLf

        txt &= "Unikatowi klienci przed 2/15/2008" & vbCrLf
        Dim query4 = From cust In all_customers, ord In all_orders _
            Where cust.CustId = ord.CustId AndAlso _
                  ord.OrderDate < #4/15/2008# _
            Select cust.FirstName & " " & cust.LastName _
            Distinct
        For Each id As String In query4
            txt &= Space$(4) & id & vbCrLf
        Next id
        txt &= vbCrLf

        ' Pamiętaj, że składnia zapytań LINQ w Visual Basic nie obsługuje
        ' Union, Intersection i Except.

        ' Pamiętaj, że tablice muszą zawierać 
        ' jeden rodzaj danych, aby używać Union,
        ' dlatego użyto CObj, aby obie zawierały obiekty Object.
        txt &= "Sclaenie klientów i zamówień" & vbCrLf
        Dim query5 = From cust In all_customers _
            Select CObj(cust)
        Dim query6 = From ord In all_orders _
            Select CObj(ord)
        Dim query7 = query5.Union(query6)
        For Each obj In query7
            txt &= Space$(4) & obj.ToString() & vbCrLf
        Next obj
        txt &= vbCrLf

        txt &= "Przecięcie klientów" & vbCrLf
        Dim query8 = From cust In all_customers, ord In all_orders _
            Where cust.CustId = ord.CustId AndAlso _
                  ord.OrderDate < #4/20/2008#
        Dim query9 = From cust In all_customers, ord In all_orders _
            Where cust.CustId = ord.CustId AndAlso _
                  ord.OrderDate > #4/10/2008#
        Dim query10 = query8.Intersect(query9)
        For Each obj In query10
            txt &= Space$(4) & obj.ToString() & vbCrLf
        Next obj
        txt &= vbCrLf

        txt &= "Wyłączenie klientów" & vbCrLf
        Dim query11 = From cust In all_customers, ord In all_orders _
            Where cust.CustId = ord.CustId AndAlso _
                  ord.OrderDate < #4/20/2008#
        Dim query12 = From cust In all_customers, ord In all_orders _
            Where cust.CustId = ord.CustId AndAlso _
                  ord.OrderDate > #4/10/2008#
        Dim query13 = query8.Except(query9)
        For Each obj In query13
            txt &= Space$(4) & obj.ToString() & vbCrLf
        Next obj
        txt &= vbCrLf

        txtResults.Text = txt
        txtResults.Select(0, 0)
    End Sub
End Class

Public Class Person
    Public FirstName As String
    Public LastName As String
    Public CustId As Integer
    Public Overrides Function ToString() As String
        Return FirstName & " " & LastName & " (" & CustId & ")"
    End Function
End Class

Public Class Order
    Public CustId As Integer
    Public OrderDate As Date
    Public OrderId As Integer
    Public Overrides Function ToString() As String
        Return "CustId: " & CustId & ", OrderId: " & OrderId & ", Date: " & OrderDate
    End Function
End Class

Public Class OrderItem
    Public OrderId As Integer
    Public Description As String
    Public UnitPrice As Decimal
    Public Quantity As Integer
    Public Overrides Function ToString() As String
        Return "OrderId: " & OrderId & ", Opis: " & Description
    End Function
End Class
