﻿Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        ' Tworzenie danych.
        Dim all_customers As New List(Of Person)
        all_customers.Add(New Person() With {.FirstName = "Ben", .LastName = "Best", .CustId = 2})
        all_customers.Add(New Person() With {.FirstName = "Frank", .LastName = "Fix", .CustId = 4})
        all_customers.Add(New Person() With {.FirstName = "Ann", .LastName = "Archer", .CustId = 5})
        all_customers.Add(New Person() With {.FirstName = "Edna", .LastName = "Ever", .CustId = 3})
        all_customers.Add(New Person() With {.FirstName = "Carly", .LastName = "Cant", .CustId = 6})
        all_customers.Add(New Person() With {.FirstName = "Dan", .LastName = "Dump", .CustId = 1})

        Dim all_orders As New List(Of Order)
        all_orders.Add(New Order() With {.CustId = 1, .OrderId = 103, .OrderDate = #4/12/2008#})
        all_orders.Add(New Order() With {.CustId = 1, .OrderId = 101, .OrderDate = #4/4/2008#})
        all_orders.Add(New Order() With {.CustId = 3, .OrderId = 102, .OrderDate = #4/7/2008#})
        all_orders.Add(New Order() With {.CustId = 1, .OrderId = 104, .OrderDate = #4/15/2008#})
        all_orders.Add(New Order() With {.CustId = 2, .OrderId = 106, .OrderDate = #4/23/2008#})
        all_orders.Add(New Order() With {.CustId = 2, .OrderId = 100, .OrderDate = #4/7/2008#})
        all_orders.Add(New Order() With {.CustId = 2, .OrderId = 105, .OrderDate = #4/19/2008#})
        all_orders.Add(New Order() With {.CustId = 3, .OrderId = 107, .OrderDate = #4/29/2008#})
        all_orders.Add(New Order() With {.CustId = 4, .OrderId = 108, .OrderDate = #5/2/2008#})
        all_orders.Add(New Order() With {.CustId = 5, .OrderId = 109, .OrderDate = #5/11/2008#})
        all_orders.Add(New Order() With {.CustId = 6, .OrderId = 110, .OrderDate = #5/15/2008#})

        Dim all_order_items As New List(Of OrderItem)
        all_order_items.Add(New OrderItem() With {.OrderId = 103, .Description = "Blue"})
        all_order_items.Add(New OrderItem() With {.OrderId = 103, .Description = "Dun"})
        all_order_items.Add(New OrderItem() With {.OrderId = 103, .Description = "Cerise"})
        all_order_items.Add(New OrderItem() With {.OrderId = 103, .Description = "Argent"})
        all_order_items.Add(New OrderItem() With {.OrderId = 100, .Description = "Apple"})
        all_order_items.Add(New OrderItem() With {.OrderId = 100, .Description = "Cherry"})
        all_order_items.Add(New OrderItem() With {.OrderId = 102, .Description = "Ash"})
        all_order_items.Add(New OrderItem() With {.OrderId = 101, .Description = "Cat"})
        all_order_items.Add(New OrderItem() With {.OrderId = 102, .Description = "Beech"})
        all_order_items.Add(New OrderItem() With {.OrderId = 101, .Description = "Bat"})
        all_order_items.Add(New OrderItem() With {.OrderId = 100, .Description = "Banana"})
        all_order_items.Add(New OrderItem() With {.OrderId = 101, .Description = "Dog"})
        all_order_items.Add(New OrderItem() With {.OrderId = 102, .Description = "Choke Cherry"})
        all_order_items.Add(New OrderItem() With {.OrderId = 101, .Description = "Ape"})
        all_order_items.Add(New OrderItem() With {.OrderId = 105, .Description = "Ace"})
        all_order_items.Add(New OrderItem() With {.OrderId = 104, .Description = "Ball"})
        all_order_items.Add(New OrderItem() With {.OrderId = 104, .Description = "Axe"})
        all_order_items.Add(New OrderItem() With {.OrderId = 104, .Description = "Club"})
        all_order_items.Add(New OrderItem() With {.OrderId = 106, .Description = "Airplane"})
        all_order_items.Add(New OrderItem() With {.OrderId = 107, .Description = "Air"})


        all_order_items.Add(New OrderItem() With {.OrderId = 108, .Description = "Arctic"})
        all_order_items.Add(New OrderItem() With {.OrderId = 109, .Description = "Alph"})
        all_order_items.Add(New OrderItem() With {.OrderId = 109, .Description = "Beta"})
        all_order_items.Add(New OrderItem() With {.OrderId = 109, .Description = "Gamma"})
        all_order_items.Add(New OrderItem() With {.OrderId = 110, .Description = "Ask"})

        ' Wybiera dane zgrupowane według klienta i zamówienia.
        Dim query1 = From cust In all_customers _
            Order By cust.LastName, cust.FirstName _
            Select TheCustomer = cust, _
                CustOrders = From ord In all_orders _
                Where cust.CustId = ord.CustId _
                Order By ord.OrderId _
                Select TheOrder = ord, _
                    OrdItems = From ord_item In all_order_items _
                    Where ord.OrderId = ord_item.OrderId _
                    Order By ord_item.Description _
                    Select TheOrderItem = ord_item

        ' Lista klientów.
        For Each cust In query1
            Dim cust_node As TreeNode = trvNestedSelect.Nodes.Add(cust.TheCustomer.ToString())

            ' Lista zamówień klienta.
            For Each ord In cust.CustOrders
                Dim order_node As TreeNode = cust_node.Nodes.Add(ord.TheOrder.ToString())

                ' Lista elementów zamówienia.
                For Each ord_item In ord.OrdItems
                    order_node.Nodes.Add(ord_item.ToString())
                Next ord_item
            Next ord

            ' Rozwinięcie poddrzewa klienta.
            cust_node.ExpandAll()
        Next cust

        ' Wybór przy użyciu Group By.
        Dim query2 = From cust In all_customers, ord In all_orders, ord_item In all_order_items _
            Where cust.CustId = ord.CustId AndAlso ord.OrderId = ord_item.OrderId _
            Order By cust.CustId, ord.OrderId, ord_item.Description _
            Group By cust Into CustomerOrdersGroup = Group _
            Select New With { _
                .TheCustomer = cust, _
                .CustOrders = _
                    From cust_orders In CustomerOrdersGroup _
                    Order By cust.CustId, cust_orders.ord.OrderId, cust_orders.ord_item.Description _
                    Group By cust_orders.ord Into OrderItemsGroup = Group _
                    Select New With { _
                        .TheOrder = ord, _
                        .OrdItems = From oi In OrderItemsGroup _
                            Order By oi.ord_item.Description _
                    } _
            }

        ' Lista klientów.
        For Each cust In query2
            Dim cust_node As TreeNode = trvNestedGroupBy.Nodes.Add(cust.TheCustomer.ToString)

            ' Lista zamówień klienta.
            For Each ord In cust.CustOrders
                Dim order_node As TreeNode = cust_node.Nodes.Add(ord.TheOrder.ToString())

                ' Lista elementów zamówienia.
                For Each ord_item In ord.OrdItems
                    order_node.Nodes.Add(ord_item.ord_item.ToString())
                Next ord_item
            Next ord

            ' Rozwinięcie poddrzewa klienta.
            cust_node.ExpandAll()
        Next cust
    End Sub
End Class

Public Class Person
    Public FirstName As String
    Public LastName As String
    Public CustId As Integer
    Public Overrides Function ToString() As String
        Return FirstName & " " & LastName & " (" & CustId & ")"
    End Function
End Class

Public Class Order
    Public CustId As Integer
    Public OrderDate As Date
    Public OrderId As Integer
    Public Overrides Function ToString() As String
        Return "CustId: " & CustId & ", OrderId: " & OrderId & ", Date: " & OrderDate
    End Function
End Class

Public Class OrderItem
    Public OrderId As Integer
    Public Description As String
    Public Overrides Function ToString() As String
        Return "OrderId: " & OrderId & ", Opis: " & Description
    End Function
End Class
