﻿Public Class Form1
    Private dsScores As DataSet
    Private dtStudents As DataTable
    Private dtScores As DataTable

    ' Inicjacja obiektu DataSet.
    Private Sub Form1_Load() Handles MyBase.Load
        ' Załadowanie danych testowych.
        LoadData()

        ' Wyświetlenie wszystkich danych.
        dgAll.DataSource = dsScores

        ' Wybór studentów z LastName < "D".
        ' Uwagi:
        '   1. Obiekt DataTable nie obsługuje zapytań. 
        '      Za pomocą AsEnumerable dokonaj konwersji na coś innego.
        '   2. Obiekt DataGrid nie może użyć zwróconej kolekcji EnumerableRowCollection
        '      jako źródła danych. Przekonwertuj ją na listę za pomocą ToList.
        Dim before_d = _
            From stu In dtStudents.AsEnumerable() _
            Where stu!LastName < "D" _
            Order By stu.Field(Of String)("LastName") _
            Select First = stu!FirstName, Last = stu!LastName
        dgStudentsBeforeD.DataSource = before_d.ToList

        ' Wybiera wszystkich studentów i ich wyniki.
        Dim joined = _
            From stu In dtStudents.AsEnumerable() _
            Join score In dtScores.AsEnumerable() _
            On stu!StudentId Equals score!StudentId _
            Order By stu!StudentId, score!TestNumber _
            Select _
                ID = stu!StudentId, _
                Name = stu!FirstName & stu!LastName, _
                Test = score!TestNumber, _
                score!Score
        dgJoined.DataSource = joined.ToList

        ' Wybiera studentów ze średnimi wynikami >= 90.
        Dim letter_grade = Function(num_score As Double) _
            Choose(num_score \ 10, _
                New Object() {"F", "F", "F", "F", "F", "D", "C", "B", "A", "A"})

        ' Dodaje Where Ave >= 90 za instrukcją Group By,
        ' aby wybrać studentów z oceną A.
        Dim grade_a = _
            From stu In dtStudents.AsEnumerable() _
                Join score In dtScores.AsEnumerable() _
                On stu!StudentId Equals score!StudentId _
            Group score By stu Into _
                Ave = Average(CInt(score!Score)), Group _
            Order By Ave _
            Select Ave, _
                Name = stu!FirstName & stu!LastName, _
                ID = stu!StudentId, _
                Grade = letter_grade(Ave)
        dgAverages.DataSource = grade_a.ToList

        ' Tworzy nową tabelę.
        Dim before_d_rows = _
            From stu In dtStudents.AsEnumerable() _
            Where stu!LastName < "D" _
            Select stu
        Dim new_table As DataTable = before_d_rows.CopyToDataTable()
        dgNewTable.DataSource = new_table

        new_table.TableName = "NewTable"
        dsScores.Tables.Add(new_table)
    End Sub

    Private Sub LoadData()
        dsScores = New DataSet("StudentScores")

        ' Tworzy tabelę Students.
        dtStudents = dsScores.Tables.Add("Students")
        dtStudents.Columns.Add("StudentId", GetType(Integer))
        dtStudents.Columns.Add("FirstName", GetType(String))
        dtStudents.Columns.Add("LastName", GetType(String))
        dtStudents.Rows.Add(New Object() {1, "Ann", "Archer"})
        dtStudents.Rows.Add(New Object() {2, "Bob", "Best"})
        dtStudents.Rows.Add(New Object() {3, "Carly", "Cant"})
        dtStudents.Rows.Add(New Object() {4, "Dan", "Dump"})
        dtStudents.Rows.Add(New Object() {5, "Edna", "Ever"})
        dtStudents.Rows.Add(New Object() {6, "Frank", "Fix"})

        ' Tworzy tabelę TestScores.
        dtScores = dsScores.Tables.Add("Scores")
        dtScores.Columns.Add("StudentId", GetType(Integer))
        dtScores.Columns.Add("TestNumber", GetType(Integer))
        dtScores.Columns.Add("Score", GetType(Integer))

        ' Tworzy losowe dane testowe.
        Dim rand As New Random
        For student_num As Integer = 1 To 2
            For test_num As Integer = 1 To 10
                dtScores.Rows.Add(New Object() { _
                    student_num, test_num, rand.Next(60, 90)})
            Next test_num
        Next student_num
        For student_num As Integer = 3 To 4
            For test_num As Integer = 1 To 10
                dtScores.Rows.Add(New Object() { _
                    student_num, test_num, rand.Next(70, 95)})
            Next test_num
        Next student_num
        For student_num As Integer = 5 To 6
            For test_num As Integer = 1 To 10
                dtScores.Rows.Add(New Object() { _
                    student_num, test_num, rand.Next(85, 101)})
            Next test_num
        Next student_num
    End Sub
End Class
