﻿Public Class Form1
    Dim emp As New Employee("Rod", "Stephens")

    ' Użycie delegatu wskazującego współdzieloną metodę klasową.
    Private Delegate Function NumEmployeesDelegate() As Integer

    Private Sub btnShared_Click() Handles btnShared.Click
        Dim show_num As NumEmployeesDelegate
        show_num = AddressOf Employee.GetNumEmployees
        MessageBox.Show(show_num().ToString, "# Employees", MessageBoxButtons.OK, MessageBoxIcon.Information)
    End Sub

    ' Użycie delegatu wskazującego metodę egzemplarza klasy.
    Private Delegate Function GetNameDelegate() As String

    Private Sub btnInstance_Click() Handles btnInstance.Click
        Dim show_name As GetNameDelegate
        show_name = AddressOf emp.ToString
        MessageBox.Show(show_name(), "Name", MessageBoxButtons.OK, MessageBoxIcon.Information)
    End Sub
End Class

Public Class Employee
    ' W prawdziwej aplikacji zwrócony zostałby rozmiar 
    ' jakiejś tablicy lub kolekcji.
    Public Shared Function GetNumEmployees() As Integer
        Return 13
    End Function

    ' Imię pracownika.
    Private m_FirstName As String = "<first name>"
    Public Property FirstName() As String
        Get
            Return m_FirstName
        End Get
        Set(ByVal value As String)
            m_FirstName = value
        End Set
    End Property

    ' Nazwisko pracownika.
    Private m_LastName As String = ""
    Public Property LastName() As String
        Get
            Return m_LastName
        End Get
        Set(ByVal value As String)
            m_LastName = value
        End Set
    End Property

    Public Sub New(ByVal first_name As String, ByVal last_name As String)
        m_FirstName = first_name
        m_LastName = last_name
    End Sub

    Public Overrides Function ToString() As String
        Return m_FirstName & " " & m_LastName
    End Function
End Class