﻿Module JobStuff
    Public Class Job
        Public JobNumber As Integer

        ''' <summary>
        ''' A list of skills required to perform this job.
        ''' </summary>
        ''' <remarks>Represent required equipment as skills.</remarks>
        Public SkillsRequired As New Collection

        ''' <summary>
        ''' The value of this job.
        ''' </summary>
        ''' <remarks>Higher numbers indicate more priority.</remarks>
        Public Priority As Integer
    End Class

    Public Class Employee
        Public FirstName As String
        Public LastName As String
        ''' <summary>
        ''' A list of skills this employee has.
        ''' </summary>
        ''' <remarks>Represent special equipment as skills.</remarks>
        Public Skills As New Collection
    End Class

    ''' <summary>
    ''' Assigns jobs to employees.
    ''' </summary>
    ''' <param name="jobs">Array of Jobs to assign.</param>
    ''' <param name="employees">Array of Employees to assign jobs.</param>
    ''' <remarks>The assignment maximizes total value of jobs assigned.</remarks>
    ''' <WrittenBy date="1/13/07">Rod Stephens</WrittenBy>
    Public Sub AssignJobs(ByVal jobs() As Job, ByVal employees() As Employee)

    End Sub
End Module
