﻿Imports System.Windows.Forms
Imports System.IO

Public Class MDIParent1
    ' Utworzenie noweg okna.
    Private Sub ShowNewForm() Handles mnuFileNew.Click, toolNew.Click, mnuWinNew.Click
        Dim frm As New Form1
        frm.MdiParent = Me
        frm.Show()
    End Sub

    ' Otwarcie pliku.
    Private Sub OpenFile() Handles mnuFileOpen.Click, toolOpen.Click
        If dlgOpen.ShowDialog(Me) = Windows.Forms.DialogResult.OK Then
            Dim frm As New Form1
            frm.FileName = dlgOpen.FileName
            frm.txtContents.Text = My.Computer.FileSystem.ReadAllText(dlgOpen.FileName)
            frm.txtContents.Select(0, 0)
            frm.Text = New FileInfo(dlgOpen.FileName).Name
            frm.MdiParent = Me
            frm.Show()
        End If
    End Sub

    ' Zapisanie pliku.
    Private Sub SaveFile() Handles toolSave.Click, mnuFileSave.Click
        ' Pobranie aktywnego formularza podrzędnego.
        Dim frm As Form1 = DirectCast(Me.ActiveMdiChild, Form1)

        ' Sprawdzenie czy jest nazwa pliku.
        If frm.FileName.Length = 0 Then
            SaveFileAs()
        Else
            ' Zapisanie pliku pod bieżącą nazwą.
            My.Computer.FileSystem.WriteAllText(frm.FileName, frm.txtContents.Text, False)
        End If
    End Sub

    ' Zapisanie pliku pod nową nazwą.
    Private Sub SaveFileAs() Handles mnuFileSaveAs.Click
        If dlgSave.ShowDialog = Windows.Forms.DialogResult.OK Then
            ' Pobranie aktywnego formularza podrzędnego.
            Dim frm As Form1 = DirectCast(Me.ActiveMdiChild, Form1)

            ' Ustawienie nazwy formularza.
            frm.FileName = dlgSave.FileName
            frm.Text = New FileInfo(dlgSave.FileName).Name

            ' Zapisanie pliku pod bieżącą nazwą.
            SaveFile()
        End If
    End Sub

    ' Koniec.
    Private Sub mnuFileExit_Click() Handles mnuFileExit.Click
        Me.Close()
    End Sub

    ' Przełącznik widoczności paska narzędzi.
    Private Sub mnuViewToolbar_Click() Handles mnuViewToolbar.Click
        Me.ToolStrip.Visible = mnuViewToolbar.Checked
    End Sub

    ' Przełącznik widoczności paska stanu.
    Private Sub mnuViewStatusBar_Click() Handles mnuViewStatusBar.Click
        Me.StatusStrip.Visible = mnuViewStatusBar.Checked
    End Sub

    ' Aranżacja potomków.
    Private Sub mnuWinCascade_Click() Handles mnuWinCascade.Click
        Me.LayoutMdi(MdiLayout.Cascade)
    End Sub

    Private Sub mnuWinTileVertical_Click() Handles mnuWinTileVertical.Click
        Me.LayoutMdi(MdiLayout.TileVertical)
    End Sub

    Private Sub mnuWinTileHorizontal_Click() Handles mnuWinTileHorizontal.Click
        Me.LayoutMdi(MdiLayout.TileHorizontal)
    End Sub

    Private Sub mnuWinArrangeIcons_Click() Handles mnuWinArrangeIcons.Click
        Me.LayoutMdi(MdiLayout.ArrangeIcons)
    End Sub

    Private Sub mnuWinMinimizeAll_Click() Handles mnuWinMinimizeAll.Click
        For Each frm As Form In Me.MdiChildren
            frm.WindowState = FormWindowState.Minimized
        Next frm
    End Sub

    Private Sub mnuWinRestoreAll_Click() Handles mnuWinRestoreAll.Click
        For Each frm As Form In Me.MdiChildren
            frm.WindowState = FormWindowState.Normal
        Next frm
    End Sub

    Private Sub mnuWinMaximizeAll_Click() Handles mnuWinMaximizeAll.Click
        For Each frm As Form In Me.MdiChildren
            frm.WindowState = FormWindowState.Maximized
        Next frm
    End Sub

    Private Sub mnuWinCloseAll_Click() Handles mnuWinCloseAll.Click
        For Each frm As Form In Me.MdiChildren
            frm.Close()
        Next
    End Sub

    Private Sub mnuWinMaximizeAll_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuWinMaximizeAll.Click

    End Sub
End Class
