﻿Imports Microsoft.DirectX
Imports Microsoft.DirectX.Direct3D

Public Class SphereForm
    ' Urządzenie Direct3D.
    Private m_Device As Device

    ' Dane.
    Private Const NUM_TRIANGLES As Integer = 80
    Private Const NUM_POINTS As Integer = 3 * NUM_TRIANGLES

    ' Bufor wierzchołków, który przechowuje dane rysunku.
    Private m_VertexBuffer As VertexBuffer = Nothing

    ' Inicjuje urządzenie graficzne. W razie powodzenia zwraca True.
    Public Function InitializeGraphics() As Boolean
        Try
            Dim params As New PresentParameters
            params.Windowed = True
            params.SwapEffect = SwapEffect.Discard
            params.EnableAutoDepthStencil = True
            params.AutoDepthStencilFormat = DepthFormat.D16

            ' Użycie sprzętowego przetwarzania wierzchołków, jeśli jest obsługiwane.
            m_Device = New Device(0, DeviceType.Hardware, Me, _
                CreateFlags.SoftwareVertexProcessing, params)

            ' Włącza bufor osi z i włącza oświetlenie.
            m_Device.RenderState.ZBufferEnable = True
            m_Device.RenderState.Lighting = True

            m_Device.RenderState.CullMode = Cull.CounterClockwise

            ' Tworzy dane wierzchołków.
            CreateVertexBuffer()

            Return True
        Catch ex As Exception
            MessageBox.Show("Błąd inicjacji Direct3D" & _
                vbCrLf & vbCrLf & ex.Message, _
                "Błąd Direct3D", MessageBoxButtons.OK)
            Return False
        End Try
    End Function

    Public Sub Render()
        If m_Device Is Nothing Then Exit Sub

        ' Czyści bufor tylny.
        m_Device.Clear(ClearFlags.Target Or ClearFlags.ZBuffer, Me.BackColor, 1, 0)

        ' Tworzy scenę.
        m_Device.BeginScene()

        ' Tworzy macierze świata, widoku oraz projekcji.
        SetupMatrices()

        ' Tworzy materiał.
        SetupMaterial()

        ' Tworzy światła.
        SetupLights()

        ' Ustawienie źródła danych strumienia urządzenia (bufor wierzchołków).
        m_Device.SetStreamSource(0, m_VertexBuffer, 0)

        ' Informuje urządzenie o formacie wierzchołków.
        m_Device.VertexFormat = CustomVertex.PositionNormal.Format

        ' Rysuje obiekty proste w strumieniu danych.
        m_Device.DrawPrimitives(PrimitiveType.TriangleList, 0, NUM_TRIANGLES)

        ' Kończy scenę i wyświetla obraz.
        m_Device.EndScene()
        m_Device.Present()
    End Sub

    ' Tworzy bufor wierzchołków urządzenia.
    Public Sub CreateVertexBuffer()
        ' Tworzy bufor wierzchołków.
        m_VertexBuffer = New VertexBuffer( _
            GetType(CustomVertex.PositionNormal), _
            NUM_POINTS, m_Device, 0, _
            CustomVertex.PositionNormal.Format, _
            Pool.Default)

        ' Blokuje bufor wierzchołków.
        ' Blokada zwraca tablicę obiektów PositionNormal.
        Dim vertices As CustomVertex.PositionNormal() = _
            CType(m_VertexBuffer.Lock(0, 0),  _
                CustomVertex.PositionNormal())
        Dim start_index As Integer = 0

        If NUM_TRIANGLES = 1 Then
            MakeTriangle(vertices, start_index, _
              0, 0, 0, _
              0, 0, 100, _
              100, 0, 0)
            'MakeTriangle(vertices, start_index, _
            '  0, 0, 100, _
            '  47.55283, 15.45085, 80.9017, _
            '  0, 50, 100)
            'MakeTriangle(vertices, start_index, _
            '  0, 0, 0, _
            '  100, 0, 0, _
            '  0, 0, 100)
        Else
            MakeTriangle(vertices, start_index, _
              0, 0, 95.10565, _
              47.55283, 15.45085, 80.9017, _
              0, 50, 80.9017)
            MakeTriangle(vertices, start_index, _
              47.55283, 15.45085, 80.9017, _
              47.55283, 65.45085, 49.99999, _
              0, 50, 80.9017)
            MakeTriangle(vertices, start_index, _
              47.55283, 15.45085, 80.9017, _
              80.9017, 26.28656, 42.53253, _
              47.55283, 65.45085, 49.99999)
            MakeTriangle(vertices, start_index, _
              0, 50, 80.9017, _
              47.55283, 65.45085, 49.99999, _
              0, 85.06508, 42.53253)
            MakeTriangle(vertices, start_index, _
              0, 0, 95.10565, _
              0, 50, 80.9017, _
              -47.55283, 15.45085, 80.9017)
            MakeTriangle(vertices, start_index, _
              0, 50, 80.9017, _
              -47.55283, 65.45085, 49.99999, _
              -47.55283, 15.45085, 80.9017)
            MakeTriangle(vertices, start_index, _
              0, 50, 80.9017, _
              0, 85.06508, 42.53253, _
              -47.55283, 65.45085, 49.99999)
            MakeTriangle(vertices, start_index, _
              -47.55283, 15.45085, 80.9017, _
              -47.55283, 65.45085, 49.99999, _
              -80.9017, 26.28656, 42.53253)
            MakeTriangle(vertices, start_index, _
              0, 0, 95.10565, _
              -47.55283, 15.45085, 80.9017, _
              -29.38927, -40.45085, 80.9017)
            MakeTriangle(vertices, start_index, _
              -47.55283, 15.45085, 80.9017, _
              -76.94209, -25, 49.99999, _
              -29.38927, -40.45085, 80.9017)
            MakeTriangle(vertices, start_index, _
              -47.55283, 15.45085, 80.9017, _
              -80.9017, 26.28656, 42.53253, _
              -76.94209, -25, 49.99999)
            MakeTriangle(vertices, start_index, _
              -29.38927, -40.45085, 80.9017, _
              -76.94209, -25, 49.99999, _
              -50, -68.81909, 42.53253)
            MakeTriangle(vertices, start_index, _
              0, 0, 95.10565, _
              -29.38927, -40.45085, 80.9017, _
              29.38927, -40.45085, 80.9017)
            MakeTriangle(vertices, start_index, _
              -29.38927, -40.45085, 80.9017, _
              0, -80.9017, 50, _
              29.38927, -40.45085, 80.9017)
            MakeTriangle(vertices, start_index, _
              -29.38927, -40.45085, 80.9017, _
              -50, -68.81909, 42.53253, _
              0, -80.9017, 50)
            MakeTriangle(vertices, start_index, _
              29.38927, -40.45085, 80.9017, _
              0, -80.9017, 50, _
              50, -68.81909, 42.53253)
            MakeTriangle(vertices, start_index, _
              0, 0, 95.10565, _
              29.38927, -40.45085, 80.9017, _
              47.55283, 15.45085, 80.9017)
            MakeTriangle(vertices, start_index, _
              29.38927, -40.45085, 80.9017, _
              76.94209, -25, 49.99999, _
              47.55283, 15.45085, 80.9017)
            MakeTriangle(vertices, start_index, _
              29.38927, -40.45085, 80.9017, _
              50, -68.81909, 42.53253, _
              76.94209, -25, 49.99999)
            MakeTriangle(vertices, start_index, _
              47.55283, 15.45085, 80.9017, _
              76.94209, -25, 49.99999, _
              80.9017, 26.28656, 42.53253)
            MakeTriangle(vertices, start_index, _
              80.9017, 26.28656, 42.53253, _
              76.94209, -25, 49.99999, _
              95.10565, 0, 0)
            MakeTriangle(vertices, start_index, _
              76.94209, -25, 49.99999, _
              76.94209, -55.9017, 0, _
              95.10565, 0, 0)
            MakeTriangle(vertices, start_index, _
              76.94209, -25, 49.99999, _
              50, -68.81909, 42.53253, _
              76.94209, -55.9017, 0)
            MakeTriangle(vertices, start_index, _
              95.10565, 0, 0, _
              76.94209, -55.9017, 0, _
              80.9017, -26.28656, -42.53253)
            MakeTriangle(vertices, start_index, _
              80.9017, 26.28656, 42.53253, _
              95.10565, 0, 0, _
              76.94209, 55.9017, 0)
            MakeTriangle(vertices, start_index, _
              95.10565, 0, 0, _
              76.94209, 25, -49.99999, _
              76.94209, 55.9017, 0)
            MakeTriangle(vertices, start_index, _
              95.10565, 0, 0, _
              80.9017, -26.28656, -42.53253, _
              76.94209, 25, -49.99999)
            MakeTriangle(vertices, start_index, _
              76.94209, 55.9017, 0, _
              76.94209, 25, -49.99999, _
              50, 68.81909, -42.53253)
            MakeTriangle(vertices, start_index, _
              80.9017, 26.28656, 42.53253, _
              76.94209, 55.9017, 0, _
              47.55283, 65.45085, 49.99999)
            MakeTriangle(vertices, start_index, _
              76.94209, 55.9017, 0, _
              29.38927, 90.45085, 0, _
              47.55283, 65.45085, 49.99999)
            MakeTriangle(vertices, start_index, _
              76.94209, 55.9017, 0, _
              50, 68.81909, -42.53253, _
              29.38927, 90.45085, 0)
            MakeTriangle(vertices, start_index, _
              47.55283, 65.45085, 49.99999, _
              29.38927, 90.45085, 0, _
              0, 85.06508, 42.53253)
            MakeTriangle(vertices, start_index, _
              0, 85.06508, 42.53253, _
              29.38927, 90.45085, 0, _
              -29.38927, 90.45085, 0)
            MakeTriangle(vertices, start_index, _
              29.38927, 90.45085, 0, _
              0, 80.9017, -50, _
              -29.38927, 90.45085, 0)
            MakeTriangle(vertices, start_index, _
              29.38927, 90.45085, 0, _
              50, 68.81909, -42.53253, _
              0, 80.9017, -50)
            MakeTriangle(vertices, start_index, _
              -29.38927, 90.45085, 0, _
              0, 80.9017, -50, _
              -50, 68.81909, -42.53253)
            MakeTriangle(vertices, start_index, _
              0, 85.06508, 42.53253, _
              -29.38927, 90.45085, 0, _
              -47.55283, 65.45085, 49.99999)
            MakeTriangle(vertices, start_index, _
              -29.38927, 90.45085, 0, _
              -76.94209, 55.9017, 0, _
              -47.55283, 65.45085, 49.99999)
            MakeTriangle(vertices, start_index, _
              -29.38927, 90.45085, 0, _
              -50, 68.81909, -42.53253, _
              -76.94209, 55.9017, 0)
            MakeTriangle(vertices, start_index, _
              -47.55283, 65.45085, 49.99999, _
              -76.94209, 55.9017, 0, _
              -80.9017, 26.28656, 42.53253)
            MakeTriangle(vertices, start_index, _
              -80.9017, 26.28656, 42.53253, _
              -76.94209, 55.9017, 0, _
              -95.10565, 0, 0)
            MakeTriangle(vertices, start_index, _
              -76.94209, 55.9017, 0, _
              -76.94209, 25, -49.99999, _
              -95.10565, 0, 0)
            MakeTriangle(vertices, start_index, _
              -76.94209, 55.9017, 0, _
              -50, 68.81909, -42.53253, _
              -76.94209, 25, -49.99999)
            MakeTriangle(vertices, start_index, _
              -95.10565, 0, 0, _
              -76.94209, 25, -49.99999, _
              -80.9017, -26.28656, -42.53253)
            MakeTriangle(vertices, start_index, _
              -80.9017, 26.28656, 42.53253, _
              -95.10565, 0, 0, _
              -76.94209, -25, 49.99999)
            MakeTriangle(vertices, start_index, _
              -95.10565, 0, 0, _
              -76.94209, -55.9017, 0, _
              -76.94209, -25, 49.99999)
            MakeTriangle(vertices, start_index, _
              -95.10565, 0, 0, _
              -80.9017, -26.28656, -42.53253, _
              -76.94209, -55.9017, 0)
            MakeTriangle(vertices, start_index, _
              -76.94209, -25, 49.99999, _
              -76.94209, -55.9017, 0, _
              -50, -68.81909, 42.53253)
            MakeTriangle(vertices, start_index, _
              -50, -68.81909, 42.53253, _
              -76.94209, -55.9017, 0, _
              -29.38927, -90.45085, 0)
            MakeTriangle(vertices, start_index, _
              -76.94209, -55.9017, 0, _
              -47.55283, -65.45085, -49.99999, _
              -29.38927, -90.45085, 0)
            MakeTriangle(vertices, start_index, _
              -76.94209, -55.9017, 0, _
              -80.9017, -26.28656, -42.53253, _
              -47.55283, -65.45085, -49.99999)
            MakeTriangle(vertices, start_index, _
              -29.38927, -90.45085, 0, _
              -47.55283, -65.45085, -49.99999, _
              0, -85.06508, -42.53253)
            MakeTriangle(vertices, start_index, _
              -50, -68.81909, 42.53253, _
              -29.38927, -90.45085, 0, _
              0, -80.9017, 50)
            MakeTriangle(vertices, start_index, _
              -29.38927, -90.45085, 0, _
              29.38927, -90.45085, 0, _
              0, -80.9017, 50)
            MakeTriangle(vertices, start_index, _
              -29.38927, -90.45085, 0, _
              0, -85.06508, -42.53253, _
              29.38927, -90.45085, 0)
            MakeTriangle(vertices, start_index, _
              0, -80.9017, 50, _
              29.38927, -90.45085, 0, _
              50, -68.81909, 42.53253)
            MakeTriangle(vertices, start_index, _
              50, -68.81909, 42.53253, _
              29.38927, -90.45085, 0, _
              76.94209, -55.9017, 0)
            MakeTriangle(vertices, start_index, _
              29.38927, -90.45085, 0, _
              47.55283, -65.45085, -49.99999, _
              76.94209, -55.9017, 0)
            MakeTriangle(vertices, start_index, _
              29.38927, -90.45085, 0, _
              0, -85.06508, -42.53253, _
              47.55283, -65.45085, -49.99999)
            MakeTriangle(vertices, start_index, _
              76.94209, -55.9017, 0, _
              47.55283, -65.45085, -49.99999, _
              80.9017, -26.28656, -42.53253)
            MakeTriangle(vertices, start_index, _
              0, 0, -95.10565, _
              29.38927, 40.45085, -80.9017, _
              47.55283, -15.45085, -80.9017)
            MakeTriangle(vertices, start_index, _
              29.38927, 40.45085, -80.9017, _
              76.94209, 25, -49.99999, _
              47.55283, -15.45085, -80.9017)
            MakeTriangle(vertices, start_index, _
              29.38927, 40.45085, -80.9017, _
              50, 68.81909, -42.53253, _
              76.94209, 25, -49.99999)
            MakeTriangle(vertices, start_index, _
              47.55283, -15.45085, -80.9017, _
              76.94209, 25, -49.99999, _
              80.9017, -26.28656, -42.53253)
            MakeTriangle(vertices, start_index, _
              0, 0, -95.10565, _
              47.55283, -15.45085, -80.9017, _
              0, -50, -80.9017)
            MakeTriangle(vertices, start_index, _
              47.55283, -15.45085, -80.9017, _
              47.55283, -65.45085, -49.99999, _
              0, -50, -80.9017)
            MakeTriangle(vertices, start_index, _
              47.55283, -15.45085, -80.9017, _
              80.9017, -26.28656, -42.53253, _
              47.55283, -65.45085, -49.99999)
            MakeTriangle(vertices, start_index, _
              0, -50, -80.9017, _
              47.55283, -65.45085, -49.99999, _
              0, -85.06508, -42.53253)
            MakeTriangle(vertices, start_index, _
              0, 0, -95.10565, _
              0, -50, -80.9017, _
              -47.55283, -15.45085, -80.9017)
            MakeTriangle(vertices, start_index, _
              0, -50, -80.9017, _
              -47.55283, -65.45085, -49.99999, _
              -47.55283, -15.45085, -80.9017)
            MakeTriangle(vertices, start_index, _
              0, -50, -80.9017, _
              0, -85.06508, -42.53253, _
              -47.55283, -65.45085, -49.99999)
            MakeTriangle(vertices, start_index, _
              -47.55283, -15.45085, -80.9017, _
              -47.55283, -65.45085, -49.99999, _
              -80.9017, -26.28656, -42.53253)
            MakeTriangle(vertices, start_index, _
              0, 0, -95.10565, _
              -47.55283, -15.45085, -80.9017, _
              -29.38927, 40.45085, -80.9017)
            MakeTriangle(vertices, start_index, _
              -47.55283, -15.45085, -80.9017, _
              -76.94209, 25, -49.99999, _
              -29.38927, 40.45085, -80.9017)
            MakeTriangle(vertices, start_index, _
              -47.55283, -15.45085, -80.9017, _
              -80.9017, -26.28656, -42.53253, _
              -76.94209, 25, -49.99999)
            MakeTriangle(vertices, start_index, _
              -29.38927, 40.45085, -80.9017, _
              -76.94209, 25, -49.99999, _
              -50, 68.81909, -42.53253)
            MakeTriangle(vertices, start_index, _
              0, 0, -95.10565, _
              -29.38927, 40.45085, -80.9017, _
              29.38927, 40.45085, -80.9017)
            MakeTriangle(vertices, start_index, _
              -29.38927, 40.45085, -80.9017, _
              0, 80.9017, -50, _
              29.38927, 40.45085, -80.9017)
            MakeTriangle(vertices, start_index, _
              -29.38927, 40.45085, -80.9017, _
              -50, 68.81909, -42.53253, _
              0, 80.9017, -50)
            MakeTriangle(vertices, start_index, _
              29.38927, 40.45085, -80.9017, _
              0, 80.9017, -50, _
              50, 68.81909, -42.53253)
        End If

        m_VertexBuffer.Unlock()
    End Sub

    Private Sub MakeTriangle( _
        ByVal vertices As CustomVertex.PositionNormal(), _
        ByRef start_index As Integer, _
        ByVal x1 As Single, ByVal y1 As Single, ByVal z1 As Single, _
        ByVal x2 As Single, ByVal y2 As Single, ByVal z2 As Single, _
        ByVal x3 As Single, ByVal y3 As Single, ByVal z3 As Single _
    )
        Const PT_SCALE As Single = 1 / 30
        x1 *= PT_SCALE
        y1 *= PT_SCALE
        z1 *= PT_SCALE
        x2 *= PT_SCALE
        y2 *= PT_SCALE
        z2 *= PT_SCALE
        x3 *= PT_SCALE
        y3 *= PT_SCALE
        z3 *= PT_SCALE

        ' Znajduje normalny wektor.
        Dim normal As Vector3
        'normal = CrossProduct( _
        '    x2 - x3, y2 - y3, z2 - z3, _
        '    x1 - x2, y1 - y2, z1 - z2)
        normal = CrossProduct( _
            x2 - x1, y2 - y1, z2 - z1, _
            x3 - x2, y3 - y2, z3 - z2)

        With vertices(start_index)
            .X = x1
            .Y = y1
            .Z = z1
            .Normal = normal
        End With
        start_index += 1

        With vertices(start_index)
            .X = x2
            .Y = y2
            .Z = z2
            .Normal = normal
        End With
        start_index += 1

        With vertices(start_index)
            .X = x3
            .Y = y3
            .Z = z3
            .Normal = normal
        End With
        start_index += 1
    End Sub

    ' Zwraca przecięcie dwóch wektorów.
    Private Function CrossProduct( _
        ByVal x1 As Single, ByVal y1 As Single, ByVal z1 As Single, _
        ByVal x2 As Single, ByVal y2 As Single, ByVal z2 As Single _
    ) As Vector3
        Dim v1 As New Vector3(x1, y1, z1)
        Dim v2 As New Vector3(x2, y2, z2)
        Return Vector3.Cross(v1, v2)
    End Function

    ' Ustawia macierze świata, widoku i projekcji.
    Private Sub SetupMatrices()
        ' Macierz świata:
        ' obraca obiekt wokół osi Y o
        ' 2 * Pi radianów na 4000 tyknięć (2 sekundy).
        Const TICKS_PER_REV As Integer = 4000
        Dim ms_rotated As Integer = Environment.TickCount Mod TICKS_PER_REV
        Dim angle As Double = ms_rotated * (2 * Math.PI) / TICKS_PER_REV
        m_Device.Transform.World = Matrix.RotationY(CSng(angle))

        ' Macierz widoku:
        ' została zdefiniowana poprzez określenie:
        '       położenia obserwatora   (0, 3, 10)
        '       położenia obiektu       (0, 0, 0)
        '       kierunku w „górę"        <0, 1, 0>
        m_Device.Transform.View = Matrix.LookAtLH( _
            New Vector3(0, 3, 10), _
            New Vector3(0, 0, 0), _
            New Vector3(0, 1, 0))

        ' Macierz projekcji:
        ' Transformacja perspektywy zdefiniowana poprzez określenie:
        '       pola widoku             Pi / 4
        '       współczynnika proporcji 1
        '       bliskiej płaszczyzny    Z = 1
        '       dalekiej płaszczyzny    Z = 100
        m_Device.Transform.Projection = _
            Matrix.PerspectiveFovLH(Math.PI / 4, 1, 1, 100)
    End Sub

    ' Tworzy materiał.
    Private Sub SetupMaterial()
        m_Device.Material = New Material() With _
            {.Ambient = Color.Gray, .Diffuse = Color.Gray}
    End Sub

    ' Tworzy światła.
    Private Sub SetupLights()
        ' Tworzy światło.
        m_Device.Lights(0).Type = LightType.Directional
        m_Device.Lights(0).Diffuse = Color.Green
        m_Device.Lights(0).Ambient = Color.DarkGreen
        m_Device.Lights(0).Direction = New Vector3(1, -1, 0)
        m_Device.Lights(0).Enabled = True

        m_Device.Lights(1).Type = LightType.Directional
        m_Device.Lights(1).Diffuse = Color.DarkRed
        m_Device.Lights(1).Ambient = Color.DarkRed
        m_Device.Lights(1).Direction = New Vector3(0, 1, 0)
        m_Device.Lights(1).Enabled = True

        ' Dodaje nieco nastrojowego światła.
        m_Device.RenderState.Ambient = Color.FromArgb(255, 32, 32, 32)
    End Sub
End Class
