﻿Public Class Form1
    Private Sub mnuFileOpen_Click() Handles mnuFileOpen.Click
        If dlgOpenImage.ShowDialog() = Windows.Forms.DialogResult.OK Then
            ' Ładuje i wyświetla obraz.
            Dim bm As New Bitmap(dlgOpenImage.FileName)
            Dim source_bm As New Bitmap(bm)
            bm.Dispose()
            picSource.Image = source_bm

            ' Ustawia kontrolki.
            picDest.Size = picSource.Size

            ' Konwertuje wynik na mapę bitową.
            Dim dest_bm As New Bitmap(source_bm)

            ' Odwraca piksele obrazu.
            Dim start_time As DateTime
            Dim stop_time As DateTime
            Dim elapsed_time As TimeSpan
            start_time = Now
            InvertImage(dest_bm)
            stop_time = Now

            ' Wyświetla wyniki.
            picDest.Image = dest_bm

            elapsed_time = stop_time.Subtract(start_time)
            MessageBox.Show(elapsed_time.TotalSeconds.ToString("0.0000") & " sekund")
        End If
    End Sub

    Private Sub InvertImage(ByVal bm As Bitmap)
        ' Przetwarza piksele obrazu.
        For y As Integer = 0 To bm.Height - 1
            For x As Integer = 0 To bm.Width - 1
                ' Pobiera kolor piksela.
                Dim clr As Color = bm.GetPixel(x, y)

                ' Odwraca komponenty koloru.
                clr = Color.FromArgb(255, _
                    255 - clr.R, _
                    255 - clr.G, _
                    255 - clr.B)

                ' Ustawia ostateczny kolor piksela.
                bm.SetPixel(x, y, clr)
            Next x
        Next y
    End Sub
End Class
