﻿Imports System.Drawing.Drawing2D
Imports System.Drawing.Text

Public Class Form1
    Private Sub Form1_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles MyBase.Paint
        ' Ustawia własności pisma i wygładzania.
        Me.Font = New Font("Times New Roman", 20, FontStyle.Bold, GraphicsUnit.Pixel)
        e.Graphics.TextRenderingHint = TextRenderingHint.AntiAliasGridFit

        ' Rysuje oryginalną strzałkę.
        DrawArrow(e.Graphics, "")

        ' Translacja o 150 w poziomie i 50 w pionie.
        e.Graphics.TranslateTransform(150, 50, MatrixOrder.Append)
        DrawArrow(e.Graphics, "A1")

        ' Rotacja o 45.
        e.Graphics.RotateTransform(45, MatrixOrder.Append)
        DrawArrow(e.Graphics, "A2")

        ' Zerowanie transformacji.
        e.Graphics.ResetTransform()

        ' Rotacja o 45 stopni.
        e.Graphics.RotateTransform(45, MatrixOrder.Append)
        DrawArrow(e.Graphics, "B1")

        ' Translacja o 150 w poziomie i 50 w pionie.
        e.Graphics.TranslateTransform(150, 50, MatrixOrder.Append)
        DrawArrow(e.Graphics, "B2")
    End Sub

    ' Rysuje obrys strzałki zawierającej tekst.
    Private Sub DrawArrow(ByVal gr As Graphics, ByVal txt As String)
        ' Rysuje strzałkę.
        Dim pts() As Point = { _
            New Point(80, 20), _
            New Point(120, 20), _
            New Point(120, 10), _
            New Point(140, 30), _
            New Point(120, 50), _
            New Point(120, 40), _
            New Point(80, 40) _
        }
        gr.FillPolygon(Brushes.White, pts)
        gr.DrawPolygon(Pens.Black, pts)

        ' Rysuje tekst.
        Dim layout_rectangle As New RectangleF(80, 20, 50, 20)
        Dim string_format As New StringFormat
        string_format.LineAlignment = StringAlignment.Center
        string_format.Alignment = StringAlignment.Center
        gr.DrawString(txt, Me.Font, Brushes.Black, _
            layout_rectangle, string_format)
    End Sub
End Class
