﻿Imports System.Drawing.Text

Public Class Form1
    Private m_Font As String = ""

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' Tworzy kolekcję zainstalowanych fontów.
        Dim installed_fonts As New InstalledFontCollection

        ' Tworzy tablicę rodzin fontów systemu.
        Dim font_families() As FontFamily = installed_fonts.Families()

        ' Wyświetla rodziny fontów.
        For Each font_family As FontFamily In font_families
            lstFonts.Items.Add(font_family.Name)
        Next font_family
        lstFonts.SelectedIndex = 0
    End Sub

    ' Wyświetla przykład.
    Private Sub lstFonts_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lstFonts.SelectedIndexChanged
        m_Font = lstFonts.SelectedItem
        picSample.Invalidate()
    End Sub

    ' Rysuje przykład.
    Private Sub picSample_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles picSample.Paint
        e.Graphics.Clear(picSample.BackColor)
        If m_Font.Length < 1 Then Exit Sub

        On Error Resume Next
        Using the_font As New Font(m_Font, 16, GraphicsUnit.Point)
            e.Graphics.DrawString("Przykład", the_font, Brushes.Black, 0, 0)
        End Using
    End Sub
End Class
