﻿' You can define and consume generic classes,
' structures, interfaces, procedures, and delegates.
Imports System.ComponentModel
Public Class Tree(Of DataType)

    ' The Root property.
    Private m_Root As TreeNode(Of DataType) = Nothing
    <Description("The tree's root node."), _
     Category("Data")> _
    Public Property Root() As TreeNode(Of DataType)
        Get
            Return m_Root
        End Get
        Set(ByVal value As TreeNode(Of DataType))
            m_Root = value
        End Set
    End Property

    ' Empty the tree.
    Public Sub Clear()
        m_Root = Nothing
    End Sub

    ' Make a new node to be the tree's root.
    Public Function MakeRoot(ByVal node_item As DataType) As TreeNode(Of DataType)
        m_Root = New TreeNode(Of DataType)(node_item)
        Return m_Root
    End Function

    ' Return a textual representation of the tree.
    Public Overrides Function ToString() As String
        Return m_Root.ToString()
    End Function
End Class

' Store an object with its neighbors.
Public Class TreeNode(Of data_type)
    Public NodeObject As data_type
    Public Children As New List(Of TreeNode(Of data_type))

    ' Initialize the new Node.
    Public Sub New(ByVal node_object As data_type)
        NodeObject = node_object
    End Sub

    ' Add a child to this node's Children list.
    Public Function AddChild(ByVal node_item As data_type) As TreeNode(Of data_type)
        Dim child_node As New TreeNode(Of data_type)(node_item)
        Children.Add(child_node)
        Return child_node
    End Function

    ' Return the subtree's string representation,
    ' suitably indented.
    Public Shadows Function ToString(Optional ByVal indent As Integer = 0) As String
        ' Add this node's text.
        Dim txt As String
        txt = New String(" "c, indent) & NodeObject.ToString & vbCrLf

        ' Add the children's text.
        For Each child As TreeNode(Of data_type) In Children
            txt &= child.ToString(indent + 2)
        Next child

        Return txt
    End Function
End Class
