﻿Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        ' Utworzenie obiektu DataSet.
        Dim scores_dataset As New DataSet("Scores")

        ' Utworzenie tabeli Students.
        Dim students_table As DataTable = _
            scores_dataset.Tables.Add("Students")

        ' Dodanie kolumn do tabeli Students.
        students_table.Columns.Add("FirstName", GetType(String))
        students_table.Columns.Add("LastName", GetType(String))
        students_table.Columns.Add("StudentId", GetType(Integer))

        ' Pole StudentId musi być unikatowe.
        students_table.Columns("StudentId").Unique = True

        ' Pary FirstName-LastName muszą być unikatowe.
        Dim first_last_columns() As DataColumn = { _
            students_table.Columns("FirstName"), _
            students_table.Columns("LastName") _
        }
        students_table.Constraints.Add( _
            New UniqueConstraint(first_last_columns))

        ' Utworzenie tabeli TestScores.
        Dim test_scores_table As DataTable = _
            scores_dataset.Tables.Add("TestScores")

        ' Dodanie kolumn do tabeli TestScores.
        test_scores_table.Columns.Add("StudentId", GetType(Integer))
        test_scores_table.Columns.Add("TestNumber", GetType(Integer))
        test_scores_table.Columns.Add("Score", GetType(Integer))

        ' Pary StudentId-TestNumber muszą być unikatowe.
        Dim studentid_testnumber_score_columns() As DataColumn = { _
            test_scores_table.Columns("StudentId"), _
            test_scores_table.Columns("TestNumber") _
        }
        test_scores_table.Constraints.Add( _
            New UniqueConstraint(studentid_testnumber_score_columns))

        ' Utworzenie związku łączącego
        ' pola StudentId obu tabel.
        scores_dataset.Relations.Add( _
            "Student Test Scores", _
            students_table.Columns("StudentId"), _
            test_scores_table.Columns("StudentId"))

        ' Dane studentów.
        students_table.Rows.Add(New Object() {"Art", "Ant", 1})
        students_table.Rows.Add(New Object() {"Bev", "Bug", 2})
        students_table.Rows.Add(New Object() {"Cid", "Cat", 3})
        students_table.Rows.Add(New Object() {"Deb", "Dove", 4})

        ' Losowe wyniki testów.
        Dim score As New Random
        For id As Integer = 1 To 4
            For test_num As Integer = 1 To 10
                test_scores_table.Rows.Add( _
                    New Object() {id, test_num, score.Next(65, 100)})
            Next test_num
        Next id

        ' Spowodowanie kilku błędów.
        students_table.Rows(1).SetColumnError(2, "Zły format nazwy")
        students_table.Rows(2).RowError = "Brakuje rejestracji"

        ' Dowiązanie DataSet do DataGrid.
        grdScores.DataSource = scores_dataset
    End Sub
End Class
