﻿Partial Public Class WizardPage3
    Inherits PageFunction(Of WizardData)

    Private m_WizardData As WizardData

    ' Zapisanie obiektu WizardData.
    Public Sub New(ByVal wizard_data As WizardData)
        InitializeComponent()

        m_WizardData = wizard_data
    End Sub

#Region "Navigation"
    ' Koniec.
    Public Sub btnFinish_Click() Handles btnFinish.Click
        m_WizardData.Canceled = False
        OnReturn(New ReturnEventArgs(Of WizardData)(m_WizardData))
    End Sub

    ' Zwrócenie wyniku oznaczającego wciśnięcie przycisku anulowania.
    Private Sub btnCancel_Click() Handles btnCancel.Click
        m_WizardData.Canceled = True
        OnReturn(New ReturnEventArgs(Of WizardData)(m_WizardData))
    End Sub

    ' Powrót do poprzedniej strony.
    Private Sub btnPrev_Click() Handles btnPrev.Click
        NavigationService.GoBack()
    End Sub
#End Region ' Nawigacja

#Region "Zapisywanie wyborów użytkownika"
    ' Zapisanie wyboru użytkownika.
    Private Sub cboDessert_SelectionChanged() Handles cboDessert.SelectionChanged
        Select Case cboDessert.SelectedIndex
            Case 0
                m_WizardData.Dessert = DessertType.None
            Case 1
                m_WizardData.Dessert = DessertType.IceCream
            Case 2
                m_WizardData.Dessert = DessertType.Cake
            Case 3
                m_WizardData.Dessert = DessertType.Pie
            Case 4
                m_WizardData.Dessert = DessertType.Cookie
            Case Else
                Debug.Assert(False, "Nieprawidłowy deser " & cboDessert.SelectedIndex)
        End Select
    End Sub
#End Region ' Zapisywanie wyborów użytkownika

End Class
