﻿Public Class Form1
    Private Sub frmDragRichText_Load() Handles MyBase.Load
        ' Tekst dla pola RichTextBox some.
        Dim txt As String = "The quick brown fox jumps over the lazy dog."
        rchSource.Text = txt

        rchSource.Select(txt.IndexOf("quick"), Len("quick"))
        rchSource.SelectionFont = New Font(rchSource.SelectionFont, FontStyle.Italic)

        rchSource.Select(txt.IndexOf("brown"), Len("brown"))
        rchSource.SelectionFont = New Font(rchSource.SelectionFont, FontStyle.Bold)
        rchSource.SelectionColor = Color.Brown

        rchSource.Select(txt.IndexOf("fox"), Len("fox"))
        rchSource.SelectionFont = New Font(rchSource.SelectionFont, FontStyle.Bold)
        rchSource.SelectionColor = Color.Red

        rchSource.Select(txt.IndexOf("jumps over"), Len("jumps over"))
        rchSource.SelectionFont = New Font(rchSource.SelectionFont, FontStyle.Underline)

        rchSource.Select(txt.IndexOf("lazy"), Len("lazy"))
        rchSource.SelectionFont = New Font(rchSource.SelectionFont, FontStyle.Bold)

        rchSource.Select(txt.IndexOf("dog"), Len("dog"))
        rchSource.SelectionFont = New Font(rchSource.SelectionFont, FontStyle.Bold)
        rchSource.SelectionColor = Color.Blue

        rchSource.Select(0, 0)
    End Sub

    ' Kopiowanie danych do schowka.
    Private Sub btnCopy_Click() Handles btnCopy.Click
        ' Utworzenie obiektu DataObject.
        Dim data_object As New DataObject

        ' Dodanie danych w różnych formatach.
        data_object.SetData(DataFormats.Rtf, rchSource.Rtf)
        data_object.SetData(DataFormats.Text, rchSource.Text)

        ' Budowa wersji HTML.
        Dim html_text As String
        html_text = "<HTML>" & vbCrLf
        html_text &= "  <HEAD>The Quick Brown Fox</HEAD>" & vbCrLf
        html_text &= "  <BODY>" & vbCrLf
        html_text &= rchSource.Text & vbCrLf
        html_text &= "  </BODY>" & vbCrLf & "</HTML>"
        data_object.SetData(DataFormats.Html, html_text)

        ' Kopiowanie danych do schowka.
        Clipboard.SetDataObject(data_object)
    End Sub

    ' Wklejenie danych ze schowka.
    Private Sub btnPaste_Click() Handles btnPaste.Click
        Dim data_object As IDataObject = Clipboard.GetDataObject()

        If data_object.GetDataPresent(DataFormats.Rtf) Then
            rchTarget.Rtf = data_object.GetData(DataFormats.Rtf).ToString
            lblRtf.Text = data_object.GetData(DataFormats.Rtf).ToString
        Else
            rchTarget.Text = ""
            lblRtf.Text = ""
        End If

        If data_object.GetDataPresent(DataFormats.Text) Then
            lblTarget.Text = data_object.GetData(DataFormats.Text).ToString
        Else
            lblTarget.Text = ""
        End If

        If data_object.GetDataPresent(DataFormats.Html) Then
            lblHtml.Text = data_object.GetData(DataFormats.Html).ToString
        Else
            lblHtml.Text = ""
        End If
    End Sub
End Class
